/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.lib.h2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.maiminhdung.customenderchest.lib.h2.engine.SysProperties;
import org.maiminhdung.customenderchest.lib.h2.mvstore.DataUtils;
import org.maiminhdung.customenderchest.lib.h2.store.fs.FileUtils;

public class IOUtils {
    private IOUtils() {
    }

    public static void closeSilently(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                IOUtils.trace("closeSilently", null, autoCloseable);
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        try {
            while (l > 0L) {
                long l2 = inputStream.skip(l);
                if (l2 <= 0L) {
                    throw new EOFException();
                }
                l -= l2;
            }
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
    }

    public static void skipFully(Reader reader, long l) throws IOException {
        try {
            while (l > 0L) {
                long l2 = reader.skip(l);
                if (l2 <= 0L) {
                    throw new EOFException();
                }
                l -= l2;
            }
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
    }

    public static long copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l = IOUtils.copyAndCloseInput(inputStream, outputStream);
            outputStream.close();
            long l2 = l;
            return l2;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }

    public static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l = IOUtils.copy(inputStream, outputStream);
            return l;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        try {
            long l2 = 0L;
            int n = (int)Math.min(l, 4096L);
            byte[] byArray = new byte[n];
            while (l > 0L && (n = inputStream.read(byArray, 0, n)) >= 0) {
                if (outputStream != null) {
                    outputStream.write(byArray, 0, n);
                }
                l2 += (long)n;
                l -= (long)n;
                n = (int)Math.min(l, 4096L);
            }
            return l2;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
    }

    public static long copy(FileChannel fileChannel, OutputStream outputStream) throws IOException {
        return IOUtils.copy(fileChannel, outputStream, Long.MAX_VALUE);
    }

    public static long copy(FileChannel fileChannel, OutputStream outputStream, long l) throws IOException {
        try {
            int n;
            long l2 = 0L;
            byte[] byArray = new byte[(int)Math.min(l, 4096L)];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            while (l > 0L && (n = fileChannel.read(byteBuffer, l2)) >= 0) {
                if (outputStream != null) {
                    outputStream.write(byArray, 0, n);
                }
                l2 += (long)n;
                byteBuffer.rewind();
                if ((l -= (long)n) >= (long)byteBuffer.limit()) continue;
                byteBuffer.limit((int)l);
            }
            return l2;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
    }

    public static long copyAndCloseInput(Reader reader, Writer writer, long l) throws IOException {
        try {
            long l2 = 0L;
            int n = (int)Math.min(l, 4096L);
            char[] cArray = new char[n];
            while (l > 0L && (n = reader.read(cArray, 0, n)) >= 0) {
                if (writer != null) {
                    writer.write(cArray, 0, n);
                }
                l2 += (long)n;
                l -= (long)n;
                n = (int)Math.min(l, 4096L);
            }
            long l3 = l2;
            return l3;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
        finally {
            reader.close();
        }
    }

    public static byte[] readBytesAndClose(InputStream inputStream, int n) throws IOException {
        try {
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            int n2 = Math.min(4096, n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream, (long)n);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringAndClose(Reader reader, int n) throws IOException {
        try {
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            int n2 = Math.min(4096, n);
            StringWriter stringWriter = new StringWriter(n2);
            IOUtils.copyAndCloseInput(reader, stringWriter, n);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n) throws IOException {
        try {
            int n2;
            int n3 = 0;
            for (int i = Math.min(n, byArray.length); i > 0 && (n2 = inputStream.read(byArray, n3, i)) >= 0; i -= n2) {
                n3 += n2;
            }
            return n3;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
    }

    public static int readFully(Reader reader, char[] cArray, int n) throws IOException {
        try {
            int n2;
            int n3 = 0;
            for (int i = Math.min(n, cArray.length); i > 0 && (n2 = reader.read(cArray, n3, i)) >= 0; i -= n2) {
                n3 += n2;
            }
            return n3;
        }
        catch (Exception exception) {
            throw DataUtils.convertToIOException(exception);
        }
    }

    public static Reader getReader(InputStream inputStream) {
        return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static Writer getBufferedWriter(OutputStream outputStream) {
        return outputStream == null ? null : new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    public static Reader getAsciiReader(InputStream inputStream) {
        return inputStream == null ? null : new InputStreamReader(inputStream, StandardCharsets.US_ASCII);
    }

    public static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("IOUtils." + string + " " + string2 + " " + object);
        }
    }

    public static InputStream getInputStreamFromString(String string) {
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    public static void copyFiles(String string, String string2) throws IOException {
        InputStream inputStream = FileUtils.newInputStream(string);
        OutputStream outputStream = FileUtils.newOutputStream(string2, false);
        IOUtils.copyAndClose(inputStream, outputStream);
    }

    public static String nameSeparatorsToNative(String string) {
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }
}

