/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.storage.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.inventory.ItemStack;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.data.ItemSerializer;
import org.maiminhdung.customenderchest.storage.StorageInterface;
import org.maiminhdung.customenderchest.storage.StorageManager;

public class MySQLStorage
implements StorageInterface {
    private final StorageManager storageManager;
    private final String tableName;

    public MySQLStorage(StorageManager storageManager) {
        this.storageManager = storageManager;
        this.tableName = EnderChest.getInstance().config().getString("storage.table_name", "custom_enderchests");
    }

    @Override
    public void init() {
        CompletableFuture.runAsync(() -> {
            String sql = "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (`player_uuid` VARCHAR(36) NOT NULL PRIMARY KEY,`player_name` VARCHAR(16),`chest_size` INT NOT NULL,`chest_data` LONGTEXT,`last_seen` BIGINT NOT NULL)";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.executeUpdate();
            }
            catch (Exception e) {
                EnderChest.getInstance().getLogger().severe("Failed to initialize MySQL table!");
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<ItemStack[]> loadEnderChest(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT chest_data FROM `" + this.tableName + "` WHERE `player_uuid` = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return null;
                ItemStack[] itemStackArray = ItemSerializer.fromBase64(rs.getString("chest_data"));
                return itemStackArray;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Integer> loadEnderChestSize(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT chest_size FROM `" + this.tableName + "` WHERE `player_uuid` = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return 0;
                Integer n = rs.getInt("chest_size");
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        });
    }

    @Override
    public CompletableFuture<Void> saveEnderChest(UUID playerUUID, String playerName, int size, ItemStack[] items) {
        return CompletableFuture.runAsync(() -> {
            String sql = "INSERT INTO `" + this.tableName + "` (player_uuid, player_name, chest_size, chest_data, last_seen) VALUES(?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE player_name = ?, chest_size = ?, chest_data = ?, last_seen = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                String data = ItemSerializer.toBase64(items);
                long timestamp = System.currentTimeMillis();
                ps.setString(1, playerUUID.toString());
                ps.setString(2, playerName);
                ps.setInt(3, size);
                ps.setString(4, data);
                ps.setLong(5, timestamp);
                ps.setString(6, playerName);
                ps.setInt(7, size);
                ps.setString(8, data);
                ps.setLong(9, timestamp);
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<Void> deleteEnderChest(UUID playerUUID) {
        return CompletableFuture.runAsync(() -> {
            String sql = "DELETE FROM `" + this.tableName + "` WHERE `player_uuid` = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<String> getPlayerName(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT player_name FROM `" + this.tableName + "` WHERE `player_uuid` = ?";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return null;
                String string = rs.getString("player_name");
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }
}

