/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.data;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.locale.LocaleManager;

public class LegacyImporter {
    private final EnderChest plugin;
    private final LocaleManager locale;

    public LegacyImporter(EnderChest plugin) {
        this.plugin = plugin;
        this.locale = plugin.getLocaleManager();
    }

    public void runImport(CommandSender sender) {
        File oldDataFolder = new File(this.plugin.getDataFolder().getParentFile(), "CustomEnderChest/PlayerData");
        if (!oldDataFolder.exists() || !oldDataFolder.isDirectory()) {
            sender.sendMessage(this.locale.getPrefixedComponent("import.no-folder", new TagResolver[0]));
            return;
        }
        File[] files = oldDataFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (files == null || files.length == 0) {
            sender.sendMessage(this.locale.getPrefixedComponent("import.no-folder", new TagResolver[0]));
            return;
        }
        sender.sendMessage(this.locale.getPrefixedComponent("import.started", new TagResolver[0]));
        CompletableFuture.runAsync(() -> {
            int total = files.length;
            int imported = 0;
            for (File file : files) {
                try {
                    UUID uuid = UUID.fromString(file.getName().replace(".yml", ""));
                    YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
                    String name = yml.getString("PlayerLastName", "Unknown");
                    int size = yml.getInt("EnderChestSize", 27);
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    for (int i = 0; i < size; ++i) {
                        items.add(yml.getItemStack("EnderChestInventory." + i));
                    }
                    this.plugin.getStorageManager().getStorage().saveEnderChest(uuid, name, size, items.toArray(new ItemStack[0])).join();
                    ++imported;
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to import legacy file: " + file.getName());
                    e.printStackTrace();
                }
            }
            TagResolver.Single finalPlaceholder = Placeholder.component((String)"imported", (ComponentLike)Component.text((int)imported));
            sender.sendMessage(this.locale.getPrefixedComponent("import.complete", new TagResolver[]{finalPlaceholder}));
        });
    }
}

