/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.lib.hikari.metrics.dropwizard;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.util.concurrent.TimeUnit;
import org.maiminhdung.customenderchest.lib.hikari.metrics.IMetricsTracker;
import org.maiminhdung.customenderchest.lib.hikari.metrics.PoolStats;

public class Dropwizard5MetricsTracker
implements IMetricsTracker {
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Histogram connectionCreation;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;

    Dropwizard5MetricsTracker(String poolName, PoolStats poolStats, MetricRegistry registry) {
        this.poolName = poolName;
        this.registry = registry;
        this.connectionObtainTimer = registry.timer(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "Wait"}));
        this.connectionUsage = registry.histogram(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "Usage"}));
        this.connectionCreation = registry.histogram(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "ConnectionCreation"}));
        this.connectionTimeoutMeter = registry.meter(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "ConnectionTimeoutRate"}));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "TotalConnections"}), (Metric)((Gauge)poolStats::getTotalConnections));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "IdleConnections"}), (Metric)((Gauge)poolStats::getIdleConnections));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "ActiveConnections"}), (Metric)((Gauge)poolStats::getActiveConnections));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "PendingConnections"}), (Metric)((Gauge)poolStats::getPendingThreads));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "MaxConnections"}), (Metric)((Gauge)poolStats::getMaxConnections));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "MinConnections"}), (Metric)((Gauge)poolStats::getMinConnections));
    }

    @Override
    public void close() {
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "Wait"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "Usage"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ConnectionCreation"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ConnectionTimeoutRate"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "TotalConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "IdleConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ActiveConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "PendingConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "MaxConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "MinConnections"}));
    }

    @Override
    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.connectionObtainTimer.update(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.connectionUsage.update(elapsedBorrowedMillis);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark();
    }

    @Override
    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.connectionCreation.update(connectionCreatedMillis);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public Histogram getConnectionCreationHistogram() {
        return this.connectionCreation;
    }
}

