/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.locale;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.utils.Text;

public class LocaleManager {
    private final EnderChest plugin;
    private FileConfiguration localeConfig;

    public LocaleManager(EnderChest plugin) {
        this.plugin = plugin;
        this.loadLocale();
    }

    public void loadLocale() {
        String localeCode = this.plugin.config().getString("general.locale", "en");
        String fileName = "lang_" + localeCode + ".yml";
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + fileName);
        if (!langFile.exists()) {
            this.plugin.getLogger().warning("Language file '" + fileName + "' not found! Attempting to save default from JAR...");
            File parentDir = langFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (InputStream in = this.plugin.getResource("lang/" + fileName);){
                if (in == null) {
                    this.plugin.getLogger().severe("FATAL: Default language file '" + fileName + "' not found in the JAR! Please ensure it exists at 'src/main/resources/lang/" + fileName + "' in your project.");
                    langFile.createNewFile();
                } else {
                    Files.copy(in, langFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Successfully created default language file: " + fileName);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create default language file: " + fileName);
                e.printStackTrace();
            }
        }
        this.localeConfig = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getRawString(String key, String defaultValue) {
        return this.localeConfig.getString(key, defaultValue);
    }

    public Component getComponent(String key, TagResolver ... placeholders) {
        String message = this.localeConfig.getString(key, "<red>Missing key: '" + key + "'</red>");
        return MiniMessage.miniMessage().deserialize(message, placeholders);
    }

    public List<Component> getComponentList(String key, TagResolver ... placeholders) {
        List messages = this.localeConfig.getStringList(key);
        if (messages.isEmpty()) {
            return Collections.singletonList(this.getComponent(key, placeholders));
        }
        return messages.stream().map(line -> Text.parse(line, placeholders)).collect(Collectors.toList());
    }

    public Component getPrefixedComponent(String key, TagResolver ... placeholders) {
        Component prefix = this.getComponent("messages.prefix", new TagResolver[0]);
        return prefix.append(this.getComponent(key, placeholders));
    }
}

