/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.lib.hikari.HikariConfig;
import org.maiminhdung.customenderchest.lib.hikari.HikariDataSource;
import org.maiminhdung.customenderchest.storage.StorageInterface;
import org.maiminhdung.customenderchest.storage.impl.H2Storage;
import org.maiminhdung.customenderchest.storage.impl.MySQLStorage;
import org.maiminhdung.customenderchest.storage.impl.YmlStorage;

public class StorageManager {
    private final EnderChest plugin;
    private HikariDataSource dataSource;
    private final StorageInterface storageImplementation;

    public StorageManager(EnderChest plugin) {
        String storageType;
        this.plugin = plugin;
        switch (storageType = plugin.config().getString("storage.type", "yml").toLowerCase()) {
            case "mysql": {
                plugin.getLogger().info("Using MySQL for data storage.");
                if (this.connectMySQL()) {
                    this.storageImplementation = new MySQLStorage(this);
                    break;
                }
                plugin.getLogger().severe("MySQL connection failed! Falling back to YML storage as a safe default.");
                this.storageImplementation = new YmlStorage(plugin);
                break;
            }
            case "h2": {
                plugin.getLogger().info("Using H2 for data storage.");
                if (this.connectH2()) {
                    this.storageImplementation = new H2Storage(this);
                    break;
                }
                plugin.getLogger().severe("H2 connection failed! Falling back to YML storage as a safe default.");
                this.storageImplementation = new YmlStorage(plugin);
                break;
            }
            default: {
                plugin.getLogger().info("Using YML for data storage.");
                this.dataSource = null;
                this.storageImplementation = new YmlStorage(plugin);
            }
        }
        this.storageImplementation.init();
    }

    private boolean connectMySQL() {
        try {
            HikariConfig config = new HikariConfig();
            config.setPoolName("CEC-MySQL-Pool");
            config.setDataSourceClassName("com.mysql.cj.jdbc.MysqlDataSource");
            config.addDataSourceProperty("serverName", this.plugin.config().getString("storage.mysql.host"));
            config.addDataSourceProperty("portNumber", this.plugin.config().getInt("storage.mysql.port", 3306));
            config.addDataSourceProperty("databaseName", this.plugin.config().getString("storage.mysql.database"));
            config.addDataSourceProperty("user", this.plugin.config().getString("storage.mysql.username"));
            config.addDataSourceProperty("password", this.plugin.config().getString("storage.mysql.password"));
            config.addDataSourceProperty("useSSL", this.plugin.config().getBoolean("storage.mysql.use-ssl"));
            config.setMaximumPoolSize(this.plugin.config().getInt("storage.pool-settings.max-pool-size", 10));
            config.setMinimumIdle(this.plugin.config().getInt("storage.pool-settings.min-idle", 5));
            config.setConnectionTimeout(this.plugin.config().getInt("storage.pool-settings.connection-timeout", 30000));
            this.dataSource = new HikariDataSource(config);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean connectH2() {
        try {
            HikariConfig config = new HikariConfig();
            config.setPoolName("CEC-H2-Pool");
            File dbFile = new File(this.plugin.getDataFolder(), "data/enderchests");
            config.setJdbcUrl("jdbc:h2:" + dbFile.getAbsolutePath());
            config.setDriverClassName("org.maiminhdung.customenderchest.lib.h2.Driver");
            config.setMaximumPoolSize(this.plugin.config().getInt("storage.pool-settings.max-pool-size", 10));
            this.dataSource = new HikariDataSource(config);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("Database connection pool closed.");
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Database is not connected (currently using YML storage).");
        }
        return this.dataSource.getConnection();
    }

    public StorageInterface getStorage() {
        return this.storageImplementation;
    }
}

