/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.storage.impl;

import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.maiminhdung.customenderchest.EnderChest;
import org.maiminhdung.customenderchest.data.ItemSerializer;
import org.maiminhdung.customenderchest.storage.StorageInterface;

public class YmlStorage
implements StorageInterface {
    private final File dataFolder;

    public YmlStorage(EnderChest plugin) {
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
    }

    private File getPlayerFile(UUID playerUUID) {
        return new File(this.dataFolder, playerUUID.toString() + ".yml");
    }

    @Override
    public CompletableFuture<ItemStack[]> loadEnderChest(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            File playerFile = this.getPlayerFile(playerUUID);
            if (!playerFile.exists()) {
                return null;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
            List serializedItems = config.getList("enderchest-inventory");
            return ItemSerializer.deserialize(serializedItems);
        });
    }

    @Override
    public CompletableFuture<Void> saveEnderChest(UUID playerUUID, String playerName, int size, ItemStack[] items) {
        return CompletableFuture.runAsync(() -> {
            File playerFile = this.getPlayerFile(playerUUID);
            YamlConfiguration config = new YamlConfiguration();
            config.set("player-name", (Object)playerName);
            config.set("enderchest-size", (Object)size);
            config.set("enderchest-inventory", ItemSerializer.serialize(items));
            try {
                config.save(playerFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void init() {
    }

    @Override
    public CompletableFuture<Integer> loadEnderChestSize(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            File playerFile = this.getPlayerFile(playerUUID);
            if (!playerFile.exists()) {
                return 0;
            }
            return YamlConfiguration.loadConfiguration((File)playerFile).getInt("enderchest-size", 0);
        });
    }

    @Override
    public CompletableFuture<Void> deleteEnderChest(UUID playerUUID) {
        return CompletableFuture.runAsync(() -> {
            File playerFile = this.getPlayerFile(playerUUID);
            if (playerFile.exists()) {
                playerFile.delete();
            }
        });
    }

    @Override
    public CompletableFuture<String> getPlayerName(UUID playerUUID) {
        return CompletableFuture.supplyAsync(() -> {
            File playerFile = this.getPlayerFile(playerUUID);
            if (!playerFile.exists()) {
                return null;
            }
            return YamlConfiguration.loadConfiguration((File)playerFile).getString("player-name");
        });
    }
}

