/*
 * Decompiled with CFR 0.152.
 */
package org.maiminhdung.customenderchest.utils;

import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.maiminhdung.customenderchest.EnderChest;

public class SoundHandler {
    private final EnderChest plugin;

    public SoundHandler(EnderChest plugin) {
        this.plugin = plugin;
    }

    public void playSound(Player player, String configPath) {
        if (this.plugin.config().getBoolean("sounds.disable-all")) {
            return;
        }
        String soundName = this.plugin.config().getString("sounds." + configPath + ".name");
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName.toUpperCase());
            float volume = (float)this.plugin.config().getDouble("sounds." + configPath + ".volume", 1.0);
            float pitch = (float)this.plugin.config().getDouble("sounds." + configPath + ".pitch", 1.0);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound name in config: '" + soundName + "' at path 'sounds." + configPath + "'");
        }
    }
}

