/*
 * Decompiled with CFR 0.152.
 */
package libs.commandapi;

import libs.commandapi.CommandAPI;
import libs.commandapi.LoadContext;
import libs.commandapi.MojangMappedVersionHandler;
import libs.commandapi.exceptions.UnsupportedVersionException;
import libs.commandapi.nms.NMS_1_20_R1;
import libs.commandapi.nms.NMS_1_20_R2;
import libs.commandapi.nms.NMS_1_20_R3;
import libs.commandapi.nms.NMS_1_20_R4;
import libs.commandapi.nms.NMS_1_21_R1;
import libs.commandapi.nms.NMS_1_21_R2;
import libs.commandapi.nms.NMS_1_21_R3;
import libs.commandapi.nms.NMS_1_21_R4;
import libs.commandapi.nms.NMS_1_21_R5;
import libs.commandapi.nms.NMS_Common;
import org.bukkit.Bukkit;

public abstract class CommandAPIVersionHandler {
    static LoadContext getPlatform() {
        String latestMajorVersion = "21";
        try {
            String currentMajorVersion;
            NMS_Common platform;
            String version;
            if (CommandAPI.getConfiguration().shouldUseLatestNMSVersion()) {
                return new LoadContext(new NMS_1_21_R5(), () -> {
                    CommandAPI.logWarning("Loading the CommandAPI with the latest and potentially incompatible NMS implementation.");
                    CommandAPI.logWarning("While you may find success with this, further updates might be necessary to fully support the version you are using.");
                });
            }
            switch (version = Bukkit.getBukkitVersion().split("-")[0]) {
                case "1.20": 
                case "1.20.1": {
                    NMS_Common nMS_Common = new NMS_1_20_R1();
                    break;
                }
                case "1.20.2": {
                    NMS_Common nMS_Common = new NMS_1_20_R2();
                    break;
                }
                case "1.20.3": 
                case "1.20.4": {
                    NMS_Common nMS_Common = new NMS_1_20_R3();
                    break;
                }
                case "1.20.5": 
                case "1.20.6": {
                    NMS_Common nMS_Common = new NMS_1_20_R4();
                    break;
                }
                case "1.21": 
                case "1.21.1": {
                    NMS_Common nMS_Common = new NMS_1_21_R1();
                    break;
                }
                case "1.21.2": 
                case "1.21.3": {
                    NMS_Common nMS_Common = new NMS_1_21_R2();
                    break;
                }
                case "1.21.4": {
                    NMS_Common nMS_Common = new NMS_1_21_R3();
                    break;
                }
                case "1.21.5": {
                    NMS_Common nMS_Common = new NMS_1_21_R4();
                    break;
                }
                case "1.21.6": 
                case "1.21.7": {
                    NMS_Common nMS_Common = new NMS_1_21_R5();
                    break;
                }
                default: {
                    NMS_Common nMS_Common = platform = null;
                }
            }
            if (platform != null) {
                return new LoadContext(platform);
            }
            if (CommandAPI.getConfiguration().shouldBeLenientForMinorVersions() && "21".equals(currentMajorVersion = version.split("\\.")[1])) {
                return new LoadContext(new NMS_1_21_R5(), () -> {
                    CommandAPI.logWarning("Loading the CommandAPI with a potentially incompatible NMS implementation.");
                    CommandAPI.logWarning("While you may find success with this, further updates might be necessary to fully support the version you are using.");
                });
            }
            throw new UnsupportedVersionException(version);
        }
        catch (Throwable error) {
            throw new IllegalStateException("The CommandAPI's NMS hook failed to load! This version of the CommandAPI is " + (MojangMappedVersionHandler.isMojangMapped() ? "Mojang" : "Spigot") + "-mapped. Have you checked that you are using a CommandAPI version that matches the mappings that your plugin is using?", error);
        }
    }
}

