/*
 * Decompiled with CFR 0.152.
 */
package libs.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import libs.commandapi.CommandAPI;
import libs.commandapi.CommandAPIHandler;
import libs.commandapi.CommandRegistrationStrategy;
import libs.commandapi.SafeVarHandle;
import libs.commandapi.SpigotCommandRegistration;
import libs.commandapi.arguments.ArgumentSubType;
import libs.commandapi.arguments.SuggestionProviders;
import libs.commandapi.commandsenders.AbstractCommandSender;
import libs.commandapi.commandsenders.BukkitCommandSender;
import libs.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import libs.commandapi.nms.NMS_Common;
import libs.commandapi.nms.NativeProxyCommandSender_1_20_R3;
import libs.commandapi.wrappers.ComplexRecipeImpl;
import libs.commandapi.wrappers.FloatRange;
import libs.commandapi.wrappers.FunctionWrapper;
import libs.commandapi.wrappers.IntegerRange;
import libs.commandapi.wrappers.Location2D;
import libs.commandapi.wrappers.NativeProxyCommandSender;
import libs.commandapi.wrappers.ParticleData;
import libs.commandapi.wrappers.Rotation;
import libs.commandapi.wrappers.ScoreboardSlot;
import libs.commandapi.wrappers.SimpleFunctionWrapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreHolder;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_20_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_20_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.entity.Entity;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class NMS_1_20_R3
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemInput;
    private static final Field serverFunctionLibraryDispatcher;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    @Override
    protected CommandBuildContext getCommandBuildContext() {
        return COMMAND_BUILD_CONTEXT;
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.t);
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.at);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.20.3", "1.20.4"};
    }

    @Override
    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).w().t_();
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        return CraftParticle.createParticleParam((org.bukkit.Particle)particle.particle(), particle.data()).a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(CommandFunction<CommandListenerWrapper> commandFunction, CommandListenerWrapper css) {
        GameProfilerFiller profiler = ((MinecraftServer)this.getMinecraftServer()).aR();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        CommandResultCallback onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, this.getBrigadierDispatcher(), (Object)css);
            CommandDispatcher.a((CommandListenerWrapper)css, executioncontext -> ExecutionContext.a((ExecutionContext)executioncontext, (InstantiatedFunction)instantiatedFunction, (ExecutionCommandSource)css, (CommandResultCallback)onCommandResult));
        }
        catch (FunctionInstantiationException instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction<CommandListenerWrapper> commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> this.runCommandFunction(commandFunction, (CommandListenerWrapper)css);
        String[] commands = new String[]{};
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, this.getBrigadierDispatcher(), null);
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (FunctionInstantiationException functionInstantiationException) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(this.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).toBukkit();
    }

    @Override
    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public final Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ResourceArgument.a(cmdCtx, (String)key, (ResourceKey)Registries.at).g().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = this.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    @Override
    public final BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    @Override
    public BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return (org.bukkit.enchantments.Enchantment)Registry.ENCHANTMENT.get(this.fromResourceLocation(BuiltInRegistries.f.b((Object)((Enchantment)ResourceArgument.g(cmdCtx, (String)key).a()))));
    }

    @Override
    public final Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (net.minecraft.world.entity.Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CommandFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction((CommandFunction<CommandListenerWrapper>)commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        MinecraftKey resourceLocation = new MinecraftKey(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aC().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CommandFunction<CommandListenerWrapper>)((CommandFunction)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aC().d()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        net.minecraft.world.item.ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = itemInput.get(input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new CraftLootTable(this.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aJ().getLootTable(resourceLocation));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return this.fromResourceLocation(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key));
    }

    @Override
    public final Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        org.bukkit.Particle particle = CraftParticle.minecraftToBukkit((Particle)particleOptions.b());
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.c());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(org.bukkit.Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, VibrationParticleOption options) {
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        PositionSource positionSource = options.c();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.c()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.d()));
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((MobEffectList)((MobEffectList)ResourceArgument.f(cmdCtx, (String)key).a()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> this.fromResourceLocation(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        RecipeHolder recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(this.fromResourceLocation(recipe.a()), recipe.toBukkitRecipe());
    }

    @Override
    public final Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F rotation = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(rotation.j, rotation.i);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key).a());
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = ArgumentScoreholder.b(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (ScoreHolder scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cy());
        }
        return scoreHolderNames;
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key).cy();
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        net.minecraft.world.entity.Entity proxyEntity;
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        CraftEntity craftEntity = proxy = (proxyEntity = css.f()) == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender_1_20_R3(css, sender, (CommandSender)proxy));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public NativeProxyCommandSender createNativeProxyCommandSender(CommandSender caller, CommandSender callee, Location location, World world) {
        if (callee == null) {
            callee = caller;
        }
        CommandListenerWrapper css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)this.wrapCommandSender(caller));
        if (location != null) {
            css = css.a(new Vec3D(location.getX(), location.getY(), location.getZ())).a(new Vec2F(location.getPitch(), location.getYaw()));
        }
        if (world == null && location != null) {
            world = location.getWorld();
        }
        if (world != null) {
            css = css.a(((CraftWorld)world).getHandle());
        }
        if (callee instanceof Entity) {
            Entity e = (Entity)callee;
            css = css.a(((CraftEntity)e).getHandle());
        }
        return new NativeProxyCommandSender_1_20_R3(css, caller, callee);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEffect soundEvent = (SoundEffect)BuiltInRegistries.b.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((SoundEffect)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).aC();
                ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aB().b().stream().map(AdvancementHolder::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aJ().a(LootDataType.c), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)BuiltInRegistries.d.e(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aC().b(new MinecraftKey(key.getNamespace(), key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CommandFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((CommandFunction<CommandListenerWrapper>)customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aC().e()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public final Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).ax;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aE();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aD().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aY().F().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aD().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        IRegistryCustom.Dimension registryAccess = ((MinecraftServer)this.getMinecraftServer()).aZ();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aD();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).av, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).ax.close();
            ((MinecraftServer)this.getMinecraftServer()).ax = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aD().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aD().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aD().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aY().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).aY().F().b()));
            ((MinecraftServer)this.getMinecraftServer()).ax.b().a((IRegistryCustom)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aX().a((IResourceManager)((MinecraftServer)this.getMinecraftServer()).ax.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bq()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.Q);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.u);
    }

    @Override
    public CommandRegistrationStrategy<CommandListenerWrapper> createCommandRegistrationStrategy() {
        return new SpigotCommandRegistration<CommandListenerWrapper>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).aE().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.a((IRegistryCustom)server2.getServer().aZ(), (FeatureFlagSet)server2.getServer().aY().F().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        itemInput = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, "c", "tag", NBTTagCompound.class);
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, "g", "dispatcher");
    }
}

