/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns;

import libs.commandapi.CommandAPI;
import libs.commandapi.CommandAPIBukkitConfig;
import libs.folialib.FoliaLib;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.Executor;
import me.vovari2.interactivesigns.ProtectionPlugins;
import me.vovari2.interactivesigns.bstats.Metrics;
import me.vovari2.interactivesigns.listeners.BreakListener;
import me.vovari2.interactivesigns.listeners.ExplodeListener;
import me.vovari2.interactivesigns.listeners.GrowListener;
import me.vovari2.interactivesigns.listeners.InteractListener;
import me.vovari2.interactivesigns.loader.ConfigurationLoader;
import me.vovari2.interactivesigns.messages.MessagesLoader;
import me.vovari2.interactivesigns.sign.SignTypes;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class InteractiveSigns
extends JavaPlugin {
    private static InteractiveSigns INSTANCE;
    private static FoliaLib FOLIA_INSTANCE;
    private String PLUGIN_NAME;
    private String VERSION;
    private String AUTHOR;
    private boolean isLoaded = false;

    public void onLoad() {
        INSTANCE = this;
        Console.LOGGER = this.getComponentLogger();
        this.PLUGIN_NAME = INSTANCE.getName();
        this.VERSION = INSTANCE.getPluginMeta().getVersion();
        this.AUTHOR = (String)INSTANCE.getPluginMeta().getAuthors().get(0);
        CommandAPI.onLoad(new CommandAPIBukkitConfig(this).verboseOutput(false));
        ProtectionPlugins.load();
    }

    public void onEnable() {
        FOLIA_INSTANCE = new FoliaLib((Plugin)this);
        long time = System.currentTimeMillis();
        CommandAPI.onEnable();
        Plugins.initialize();
        ProtectionPlugins.initialize();
        Executor.pre_register(this);
        this.isLoaded = MessagesLoader.initialize() && ConfigurationLoader.initialize();
        this.initializeListeners();
        new Metrics(this, 26326);
        if (this.isLoaded) {
            SignTypes.initialize();
            Executor.register(this);
            Console.info("<green>Plugin {} {} enabled! ({} ms)", this.PLUGIN_NAME, this.VERSION, System.currentTimeMillis() - time);
        } else {
            Console.warn("Plugin {} {} is not enabled! There was an error in the console above!", this.PLUGIN_NAME, this.VERSION);
        }
    }

    public void onDisable() {
        CommandAPI.onDisable();
        HandlerList.unregisterAll((Plugin)this);
        Console.info("<red>Plugin {} {} disabled!", this.PLUGIN_NAME, this.VERSION);
    }

    public void onReload() {
        long time = System.currentTimeMillis();
        Executor.pre_register(this);
        this.isLoaded = MessagesLoader.initialize() && ConfigurationLoader.initialize();
        HandlerList.unregisterAll((Plugin)this);
        this.initializeListeners();
        if (this.isLoaded) {
            SignTypes.initialize();
            Executor.register(this);
            Console.info("<green>Plugin {} {} reloaded! ({} ms)", this.PLUGIN_NAME, this.VERSION, System.currentTimeMillis() - time);
        } else {
            Console.warn("Plugin {} {} is not reloaded! There was an error in the console above!", this.PLUGIN_NAME, this.VERSION);
        }
    }

    private void initializeListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ExplodeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GrowListener(), (Plugin)this);
    }

    public static InteractiveSigns getInstance() {
        return INSTANCE;
    }

    public static FoliaLib getFoliaInstance() {
        return FOLIA_INSTANCE;
    }

    public static String getPluginName() {
        return InteractiveSigns.INSTANCE.PLUGIN_NAME;
    }

    public static String getVersion() {
        return InteractiveSigns.INSTANCE.VERSION;
    }

    public static String getAuthor() {
        return InteractiveSigns.INSTANCE.AUTHOR;
    }

    public static enum Plugins {
        CoreProtect("CoreProtect", plugin -> {
            Plugin javaPlugin = INSTANCE.getServer().getPluginManager().getPlugin("CoreProtect");
            if (!(javaPlugin instanceof CoreProtect)) {
                return false;
            }
            CoreProtect coreProtect = (CoreProtect)javaPlugin;
            Console.info("Found CoreProtect plugin!", new Object[0]);
            CoreProtectAPI api = coreProtect.getAPI();
            if (!api.isEnabled()) {
                Console.error("CoreProtect plugin API is not enabled!", new Object[0]);
                return false;
            }
            if (api.APIVersion() < 10) {
                Console.error("CoreProtect plugin unsupported version v%s (needed v22.4+)!".formatted(coreProtect.getDescription().getVersion()), new Object[0]);
                return false;
            }
            Console.info("Full support for CoreProtect plugin!", new Object[0]);
            return true;
        }, () -> {}),
        PlaceholderAPI("PlaceholderAPI", plugin -> {
            if (InteractiveSigns.getInstance().getServer().getPluginManager().getPlugin(plugin.name) == null) {
                return false;
            }
            Console.info("Found and connected to PlaceholderAPI plugin!", new Object[0]);
            return true;
        }, () -> {});

        private final String name;
        private final EnableOperation enableOperation;
        private final InitializationOperation initializationOperation;
        private boolean enabled;

        static void initialize() {
            for (Plugins plugin : Plugins.values()) {
                plugin.enabled = plugin.enableOperation.isEnable(plugin);
                if (!plugin.isEnabled()) continue;
                plugin.initializationOperation.run();
            }
        }

        private Plugins(String name, EnableOperation enableOperation, InitializationOperation initializationOperation) {
            this.name = name;
            this.enableOperation = enableOperation;
            this.initializationOperation = initializationOperation;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        private static interface EnableOperation {
            public boolean isEnable(@NotNull Plugins var1);
        }

        private static interface InitializationOperation {
            public void run();
        }
    }
}

