/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.InteractiveSigns;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    public static File getPluginFolder() {
        return InteractiveSigns.getInstance().getDataFolder();
    }

    private static File createPluginFolder() {
        File pluginFolder = FileUtils.getPluginFolder();
        try {
            boolean bl = pluginFolder.mkdir();
        }
        catch (Exception e) {
            Console.error("Error when creating a folder \"{}\"!", pluginFolder.getName());
        }
        return pluginFolder;
    }

    public static void createFolder(File folder) {
        boolean ignored = folder.mkdir();
    }

    @NotNull
    public static File createFolder(File parentFolder, String folderName) {
        File folder = new File(parentFolder, folderName);
        boolean ignored = folder.mkdir();
        return folder;
    }

    public static void createFileInFolder(File folder, File file) {
        try {
            Path path = Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            Console.error("Error when creating a file '{}' in folder '{}'!", file.getName(), folder.getName());
        }
    }

    public static void createResourceFileInFolder(String resourcePath) {
        File pluginFolder = FileUtils.createPluginFolder();
        File file = new File(pluginFolder, resourcePath);
        if (!file.exists()) {
            InteractiveSigns.getInstance().saveResource(resourcePath, false);
        }
    }

    public static String getContentFromFile(File file) {
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            Console.error("Error when loading data from a file \"{}\"!", file.getName());
            return null;
        }
    }

    public static void setContentInFile(File file, String content) {
        try (FileWriter writer = new FileWriter(file, false);){
            writer.append(content);
        }
        catch (IOException e) {
            Console.error("Error when saving content in a file \"{}\"!", file.getName());
        }
    }

    public static YamlConfiguration getContentFromYamlFile(File folder, String fileName) {
        return YamlConfiguration.loadConfiguration((File)new File(folder, fileName));
    }

    public static void setContentInYamlFile(File folder, String fileName, FileConfiguration configuration) {
        try {
            configuration.save(new File(folder, fileName));
        }
        catch (Exception e) {
            Console.error("Error when saving content in a yaml file \"{}\"!", fileName);
        }
    }
}

