/*
 * Decompiled with CFR 0.152.
 */
package libs.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import libs.commandapi.arguments.CommandAPIArgumentType;
import libs.commandapi.arguments.SafeOverrideableArgument;
import libs.commandapi.exceptions.InvalidRangeException;
import libs.commandapi.executors.CommandArguments;

public class FloatArgument
extends SafeOverrideableArgument<Float, Float> {
    public FloatArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg(), String::valueOf);
    }

    public FloatArgument(String nodeName, float min) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min), String::valueOf);
    }

    public FloatArgument(String nodeName, float min, float max) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min, (float)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Float> getPrimitiveType() {
        return Float.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_FLOAT;
    }

    @Override
    public <Source> Float parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Float)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

