/*
 * Decompiled with CFR 0.152.
 */
package libs.commandapi.arguments;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import libs.commandapi.IStringTooltip;
import libs.commandapi.SuggestionInfo;
import libs.commandapi.Tooltip;
import libs.commandapi.arguments.ArgumentSuggestions;

@FunctionalInterface
public interface SafeSuggestions<S, CommandSender> {
    public ArgumentSuggestions<CommandSender> toSuggestions(Function<S, String> var1);

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> empty() {
        return mapper -> ArgumentSuggestions.empty();
    }

    @SafeVarargs
    public static <T, CommandSender> SafeSuggestions<T, CommandSender> suggest(T ... suggestions) {
        return mapper -> ArgumentSuggestions.strings(SafeSuggestions.toStrings(mapper, suggestions));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> suggest(Collection<T> suggestions) {
        return mapper -> ArgumentSuggestions.strings(SafeSuggestions.toStrings(mapper, suggestions));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> suggest(Function<SuggestionInfo<CommandSender>, T[]> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollection(info -> SafeSuggestions.toStrings(mapper, (Object[])suggestions.apply((SuggestionInfo)info)));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> suggestCollection(Function<SuggestionInfo<CommandSender>, Collection<T>> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollection(info -> SafeSuggestions.toStrings(mapper, (Collection)suggestions.apply((SuggestionInfo)info)));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> suggestAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<T[]>> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStrings(mapper, items)));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> suggestCollectionAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<Collection<T>>> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStrings(mapper, items)));
    }

    @SafeVarargs
    public static <T, CommandSender> SafeSuggestions<T, CommandSender> tooltips(Tooltip<T> ... suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltips(SafeSuggestions.toStringsWithTooltips(mapper, suggestions));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> tooltips(Collection<Tooltip<T>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltips(SafeSuggestions.toStringsWithTooltips(mapper, suggestions));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> tooltips(Function<SuggestionInfo<CommandSender>, Tooltip<T>[]> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollection(info -> SafeSuggestions.toStringsWithTooltips(mapper, (Tooltip[])suggestions.apply((SuggestionInfo)info)));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> tooltipCollection(Function<SuggestionInfo<CommandSender>, Collection<Tooltip<T>>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollection(info -> SafeSuggestions.toStringsWithTooltips(mapper, (Collection)suggestions.apply((SuggestionInfo)info)));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> tooltipsAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<Tooltip<T>[]>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStringsWithTooltips(mapper, items)));
    }

    public static <T, CommandSender> SafeSuggestions<T, CommandSender> tooltipCollectionAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<Collection<Tooltip<T>>>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStringsWithTooltips(mapper, items)));
    }

    @SafeVarargs
    private static <T> Collection<String> toStrings(Function<T, String> mapper, T ... suggestions) {
        return Arrays.stream(suggestions).map(mapper).toList();
    }

    private static <T> Collection<String> toStrings(Function<T, String> mapper, Collection<T> suggestions) {
        return suggestions.stream().map(mapper).toList();
    }

    @SafeVarargs
    private static <T> Collection<IStringTooltip> toStringsWithTooltips(Function<T, String> mapper, Tooltip<T> ... suggestions) {
        return SafeSuggestions.toStringsWithTooltips(mapper, Arrays.stream(suggestions));
    }

    private static <T> Collection<IStringTooltip> toStringsWithTooltips(Function<T, String> mapper, Collection<Tooltip<T>> suggestions) {
        return SafeSuggestions.toStringsWithTooltips(mapper, suggestions.stream());
    }

    private static <T> Collection<IStringTooltip> toStringsWithTooltips(Function<T, String> mapper, Stream<Tooltip<T>> suggestions) {
        Function<Tooltip, IStringTooltip> builder = Tooltip.build(mapper)::apply;
        return suggestions.map(builder).toList();
    }
}

