/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.loader;

import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public abstract class Loader {
    protected YamlConfiguration configuration;

    protected Loader() {
    }

    @NotNull
    protected Object getObject(@NotNull String path) throws Exception {
        Object object = this.configuration.get(path);
        if (object == null) {
            throw new Exception("Value '%s' must not be a null!".formatted(path));
        }
        return object;
    }

    @Nullable
    protected Object getObject(@NotNull String path, @Nullable Object def) {
        Object object = this.configuration.get(path);
        return object == null ? def : object;
    }

    protected boolean getBoolean(@NotNull String path) throws Exception {
        Object object = this.getObject(path);
        if (!(object instanceof Boolean)) {
            throw new Exception("<red>Value '%s' must be true or false!".formatted(path));
        }
        Boolean value = (Boolean)object;
        return value;
    }

    protected boolean getBoolean(@NotNull String path, boolean def) throws Exception {
        boolean bl;
        Object object = this.getObject(path);
        if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            bl = value;
        } else {
            bl = def;
        }
        return bl;
    }

    protected int getInt(@NotNull String path) throws Exception {
        Object object = this.getObject(path);
        if (!(object instanceof Integer)) {
            throw new Exception("Value '%s' must be an integer!".formatted(path));
        }
        Integer value = (Integer)object;
        return value;
    }

    protected int getInt(@NotNull String path, int min) throws Exception {
        int value = this.getInt(path);
        if (value < min) {
            throw new Exception("Value '%s' must be greater than %s!".formatted(path, min));
        }
        return value;
    }

    protected double getDouble(@NotNull String path) throws Exception {
        Object object = this.getObject(path);
        if (!(object instanceof Double)) {
            throw new Exception("<red>Value '%s' must be a double!".formatted(path));
        }
        Double value = (Double)object;
        return value;
    }

    @NotNull
    protected String getString(@NotNull String path) throws Exception {
        String value = this.configuration.getString(path);
        if (value == null) {
            throw new Exception("Value '%s' must not be a null!".formatted(path));
        }
        return value;
    }

    @Nullable
    protected String getString(@NotNull String path, @Nullable String def) throws Exception {
        String value = this.configuration.getString(path);
        return value == null ? def : value;
    }

    @Nullable
    protected Material getMaterial(@NotNull String path, @Nullable Material def) {
        String value = this.configuration.getString(path, null);
        if (value == null) {
            return def;
        }
        try {
            return Material.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }

    @NotNull
    protected Material getMaterial(@NotNull String value, @NotNull String path) throws Exception {
        try {
            return Material.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new Exception("<red>Value '%s' must be a material!".formatted(path));
        }
    }

    @Nullable
    protected EntityType getEntityType(@NotNull String path, @Nullable EntityType def) throws Exception {
        String value = this.getString(path, null);
        if (value == null) {
            return def;
        }
        try {
            return EntityType.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }

    @NotNull
    protected EntityType getEntityType(@NotNull String value, @NotNull String path) throws Exception {
        try {
            return EntityType.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new Exception("<red>Value '%s' must be an entity type!".formatted(path));
        }
    }
}

