/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.messages;

import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.loader.Loader;
import me.vovari2.interactivesigns.messages.MessageType;
import me.vovari2.interactivesigns.messages.Messages;
import me.vovari2.interactivesigns.messages.types.ActionbarMessage;
import me.vovari2.interactivesigns.messages.types.BossbarMessage;
import me.vovari2.interactivesigns.messages.types.ChatMessage;
import me.vovari2.interactivesigns.messages.types.TitleMessage;
import me.vovari2.interactivesigns.utils.FileUtils;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.title.Title;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesLoader
extends Loader {
    public static boolean initialize() {
        try {
            new MessagesLoader("messages.yml");
            return true;
        }
        catch (Exception e) {
            Console.error("Error loading messages: " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    private MessagesLoader(@NotNull String fileName) throws Exception {
        File pluginFolder = FileUtils.getPluginFolder();
        File file = new File(pluginFolder, fileName);
        if (!file.exists()) {
            this.configuration = new YamlConfiguration();
            for (Messages message : Messages.values()) {
                this.configuration.set(message.name().replaceAll("_", "-").toLowerCase(), (Object)message.string());
            }
            FileUtils.createFolder(pluginFolder);
            FileUtils.createFileInFolder(pluginFolder, file);
            FileUtils.setContentInYamlFile(pluginFolder, fileName, (FileConfiguration)this.configuration);
        } else {
            this.configuration = FileUtils.getContentFromYamlFile(pluginFolder, fileName);
            for (Messages object : Messages.values()) {
                String path = object.name().replaceAll("_", "-").toLowerCase();
                ConfigurationSection section = this.configuration.getConfigurationSection(path);
                if (section == null) {
                    object.setMessage(new ChatMessage(object, this.getStringFromSection(path)));
                    continue;
                }
                String message = this.getStringFromSection("%s.message".formatted(path));
                MessageType type = this.getMessageType("%s.type".formatted(path), MessageType.CHAT);
                object.setMessage(switch (type) {
                    default -> throw new IncompatibleClassChangeError();
                    case MessageType.CHAT -> new ChatMessage(object, message);
                    case MessageType.ACTIONBAR -> new ActionbarMessage(object, message);
                    case MessageType.BOSSBAR -> {
                        BossBar.Color color = this.getBossbarColor("%s.color".formatted(path), BossBar.Color.YELLOW);
                        BossBar.Overlay overlay = this.getBossbarOverlay("%s.overlay".formatted(path), BossBar.Overlay.NOTCHED_6);
                        yield new BossbarMessage(object, message, color, overlay, this.configuration.getInt("%s.stay-time", 100));
                    }
                    case MessageType.TITLE -> {
                        String subtitle = this.getString("%s.subtitle".formatted(path), "");
                        Duration fadeIn = this.getDuration("%s.fade-in".formatted(path), Duration.of(500L, ChronoUnit.MILLIS));
                        Duration stay = this.getDuration("%s.stay".formatted(path), Duration.of(3500L, ChronoUnit.MILLIS));
                        Duration fadeOut = this.getDuration("%s.fade-out".formatted(path), Duration.of(1000L, ChronoUnit.MILLIS));
                        yield new TitleMessage(object, message, subtitle, Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut));
                    }
                });
            }
        }
    }

    @Nullable
    private String getStringFromSection(@NotNull String path) throws Exception {
        List messages = this.configuration.getStringList(path);
        return messages.isEmpty() ? super.getString(path, null) : String.join((CharSequence)"\n", messages);
    }

    @NotNull
    private MessageType getMessageType(@NotNull String path, @NotNull MessageType def) {
        try {
            return MessageType.valueOf(this.getString(path).toUpperCase());
        }
        catch (Exception e) {
            return def;
        }
    }

    @NotNull
    private Duration getDuration(@NotNull String path, @NotNull Duration def) throws Exception {
        String strValue = this.configuration.getString(path);
        if (strValue == null) {
            return def;
        }
        if (!strValue.matches("^\\d+[stm]$")) {
            throw new Exception("<red>Value '%s' has invalid format!".formatted(path));
        }
        int intValue = Integer.parseInt(strValue.substring(0, strValue.length() - 1));
        return Duration.of(intValue *= (switch (strValue.substring(strValue.length() - 1)) {
            case "s" -> 1000;
            case "t" -> 50;
            default -> 1;
        }), ChronoUnit.MILLIS);
    }

    @NotNull
    private BossBar.Color getBossbarColor(@NotNull String path, @NotNull BossBar.Color def) {
        try {
            return BossBar.Color.valueOf((String)this.getString(path).toUpperCase());
        }
        catch (Exception e) {
            return def;
        }
    }

    @NotNull
    private BossBar.Overlay getBossbarOverlay(@NotNull String path, @NotNull BossBar.Overlay def) {
        try {
            return BossBar.Overlay.valueOf((String)this.getString(path).toUpperCase());
        }
        catch (Exception e) {
            return def;
        }
    }
}

