/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.messages.types;

import java.util.HashMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.vovari2.interactivesigns.Delay;
import me.vovari2.interactivesigns.InteractiveSigns;
import me.vovari2.interactivesigns.messages.MessageType;
import me.vovari2.interactivesigns.messages.Messages;
import me.vovari2.interactivesigns.messages.StringMessage;
import me.vovari2.interactivesigns.utils.TextUtils;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossbarMessage
extends StringMessage {
    private final BossBar.Color color;
    private final BossBar.Overlay overlay;
    private final int stayTime;

    public BossbarMessage(@NotNull Messages key, @Nullable String message, @NotNull BossBar.Color color, @NotNull BossBar.Overlay overlay, int stayTime) {
        super(key, message, MessageType.BOSSBAR);
        this.color = color;
        this.overlay = overlay;
        this.stayTime = stayTime;
    }

    @Override
    public void send(@NotNull CommandSender sender) {
        if (this.isEmpty()) {
            return;
        }
        sender.sendMessage("Bossbar cannot be displayed!");
    }

    @Override
    public void send(@NotNull Player player) {
        this.send(player, 1.0f);
    }

    public void send(final @NotNull Player player, float bossbarValue) {
        if (this.isEmpty()) {
            return;
        }
        Delay.run(this.key, (CommandSender)player, () -> {
            final BossBar bossBar = BossBar.bossBar((Component)TextUtils.toComponent(InteractiveSigns.Plugins.PlaceholderAPI.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)this.message) : this.message), (float)bossbarValue, (BossBar.Color)this.color, (BossBar.Overlay)this.overlay);
            player.showBossBar(bossBar);
            AutoHideBossbarMessage.start(player.getUniqueId(), new BukkitRunnable(){

                public void run() {
                    player.hideBossBar(bossBar);
                }
            });
        });
    }

    @Override
    @NotNull
    public StringMessage replace(@NotNull String placeholder, @NotNull String replacement) {
        return new BossbarMessage(this.key, this.message.replaceAll("<%" + placeholder + "%>", replacement), this.color, this.overlay, this.stayTime);
    }

    @Override
    @NotNull
    public StringMessage replace(@NotNull String placeholder, long replacement) {
        return this.replace(placeholder, String.valueOf(replacement));
    }

    public static class AutoHideBossbarMessage {
        private static final HashMap<UUID, RunnableAndTask> tasks = new HashMap();

        public static void start(@NotNull UUID player, @NotNull BukkitRunnable runnable) {
            if (tasks.containsKey(player)) {
                RunnableAndTask task = tasks.get(player);
                task.runnable.run();
                task.task.cancel();
            }
            tasks.put(player, new RunnableAndTask(runnable, runnable.runTaskLater((Plugin)InteractiveSigns.getInstance(), 100L)));
        }

        private record RunnableAndTask(BukkitRunnable runnable, BukkitTask task) {
        }
    }
}

