/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.messages.types;

import me.clip.placeholderapi.PlaceholderAPI;
import me.vovari2.interactivesigns.Delay;
import me.vovari2.interactivesigns.InteractiveSigns;
import me.vovari2.interactivesigns.messages.MessageType;
import me.vovari2.interactivesigns.messages.Messages;
import me.vovari2.interactivesigns.messages.StringMessage;
import me.vovari2.interactivesigns.utils.TextUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleMessage
extends StringMessage {
    private final String subtitle;
    private final Title.Times times;

    public TitleMessage(@NotNull Messages key, @Nullable String title, @Nullable String subtitle, @NotNull Title.Times times) {
        super(key, title, MessageType.TITLE);
        this.subtitle = subtitle == null ? "" : subtitle;
        this.times = times;
    }

    @Override
    public void send(@NotNull CommandSender sender) {
        if (this.isEmpty()) {
            return;
        }
        sender.sendMessage("Title cannot be displayed!");
    }

    @Override
    public void send(@NotNull Player player) {
        if (this.isEmpty()) {
            return;
        }
        Delay.run(this.key, (CommandSender)player, () -> player.showTitle(Title.title((Component)TextUtils.toComponent(InteractiveSigns.Plugins.PlaceholderAPI.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)this.message) : this.message), (Component)TextUtils.toComponent(this.subtitle), (Title.Times)this.times)));
    }

    @Override
    @NotNull
    public StringMessage replace(@NotNull String placeholder, @NotNull String replacement) {
        return new TitleMessage(this.key, this.message.replaceAll("<%" + placeholder + "%>", replacement), this.subtitle.replaceAll("<%" + placeholder + "%>", replacement), this.times);
    }

    @Override
    @NotNull
    public StringMessage replace(@NotNull String placeholder, long replacement) {
        return this.replace(placeholder, String.valueOf(replacement));
    }
}

