/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns;

import java.util.List;
import me.vovari2.interactivesigns.InteractiveSigns;
import me.vovari2.interactivesigns.messages.Messages;
import me.vovari2.interactivesigns.utils.NamespacedKeyUtils;
import me.vovari2.interactivesigns.utils.TextUtils;
import net.kyori.adventure.audience.Audience;
import org.bukkit.block.sign.Side;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Executor {
    private static final String PERMISSION = "interactive_signs.*";

    public static boolean hasPermission(@NotNull Player player) {
        return player.hasPermission(PERMISSION);
    }

    public static void register(InteractiveSigns instance) {
        instance.getServer().getCommandMap().register(InteractiveSigns.getPluginName(), (Command)new InteractiveSignsCommand("interactivesings", "", "/ins <args>", List.of("ins")));
    }

    private static class InteractiveSignsCommand
    extends BukkitCommand {
        public InteractiveSignsCommand(@NotNull String name, @NotNull String description, @NotNull String usageMessage, @NotNull List<String> aliases) {
            super(name, description, usageMessage, aliases);
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String @NotNull [] args) {
            if (args.length < 1) {
                sender.sendMessage(TextUtils.toComponent("<red>Invalid command entered!"));
                return true;
            }
            if (!sender.hasPermission(Executor.PERMISSION) && !sender.isOp()) {
                sender.sendMessage(TextUtils.toComponent("<red>You don't have permission!"));
                return true;
            }
            switch (args[0]) {
                case "help": {
                    Messages.COMMAND_HELP.send((Audience)sender);
                    break;
                }
                case "reload": {
                    if (args.length == 1) {
                        Messages.COMMAND_RELOAD.send((Audience)sender);
                        return true;
                    }
                    if (args.length != 2 || !args[1].equals("confirm")) break;
                    InteractiveSigns.getInstance().onReload();
                    Messages.COMMAND_RELOAD_CONFIRM.send((Audience)sender);
                    return true;
                }
                case "clear": {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(TextUtils.toComponent("<yellow>This command can only be executed by the player!"));
                        return true;
                    }
                    Player player = (Player)sender;
                    if (args.length > 2) {
                        sender.sendMessage("<yellow>Too many arguments!");
                        return true;
                    }
                    double radius = 1.0;
                    if (args.length == 2) {
                        try {
                            radius = Double.parseDouble(args[1]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(TextUtils.toComponent("<yellow>Invalid format for cleaning radius!"));
                            return true;
                        }
                    }
                    for (ItemDisplay display2 : player.getWorld().getNearbyEntitiesByType(ItemDisplay.class, player.getLocation(), radius, display -> display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSign(Side.FRONT.name())) || display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSign(Side.BACK.name())))) {
                        player.getInventory().addItem(new ItemStack[]{display2.getItemStack()});
                        display2.remove();
                    }
                    Messages.COMMAND_CLEAR.replace("radius", String.valueOf(radius)).send((Audience)player);
                    break;
                }
                default: {
                    sender.sendMessage(TextUtils.toComponent("<red>Invalid command entered!"));
                }
            }
            return true;
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
            if (args.length == 1) {
                return List.of("help", "reload", "clear");
            }
            if (args.length == 2) {
                return switch (args[0]) {
                    case "reload" -> List.of("confirm");
                    case "clear" -> List.of("1", "5", "10");
                    default -> List.of();
                };
            }
            return List.of();
        }
    }
}

