/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns;

import java.util.HashMap;
import libs.folialib.FoliaLib;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.Executor;
import me.vovari2.interactivesigns.Plugins;
import me.vovari2.interactivesigns.ProtectionPlugins;
import me.vovari2.interactivesigns.bstats.Metrics;
import me.vovari2.interactivesigns.listeners.BreakListener;
import me.vovari2.interactivesigns.listeners.ExplodeListener;
import me.vovari2.interactivesigns.listeners.GrowListener;
import me.vovari2.interactivesigns.listeners.InteractListener;
import me.vovari2.interactivesigns.loaders.types.ConfigurationLoader;
import me.vovari2.interactivesigns.loaders.types.MessagesLoader;
import me.vovari2.interactivesigns.sign.SignTypes;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class InteractiveSigns
extends JavaPlugin {
    private static InteractiveSigns INSTANCE;
    private static FoliaLib FOLIA_INSTANCE;
    private String PLUGIN_NAME;
    private String VERSION;
    private String AUTHOR;
    private boolean isConfigurationLoaded = false;

    public void onLoad() {
        INSTANCE = this;
        Console.LOGGER = this.getComponentLogger();
        this.PLUGIN_NAME = INSTANCE.getName();
        this.VERSION = INSTANCE.getPluginMeta().getVersion();
        this.AUTHOR = (String)INSTANCE.getPluginMeta().getAuthors().getFirst();
        Plugins.load();
        ProtectionPlugins.load();
    }

    public void onEnable() {
        FOLIA_INSTANCE = new FoliaLib((Plugin)this);
        long time = System.currentTimeMillis();
        Plugins.enable();
        ProtectionPlugins.initialize();
        Executor.register(this);
        this.isConfigurationLoaded = MessagesLoader.initialize() && ConfigurationLoader.initialize();
        this.registerListeners();
        this.registerMetrics();
        SignTypes.initialize();
        if (this.isConfigurationLoaded) {
            Console.info("<green>Plugin {} {} enabled! ({} ms)", this.PLUGIN_NAME, this.VERSION, System.currentTimeMillis() - time);
        } else {
            Console.warn("Plugin {} {} is not enabled! There was an error in the console above!", this.PLUGIN_NAME, this.VERSION);
        }
    }

    public void onDisable() {
        this.unregisterListeners();
        Console.info("<red>Plugin {} {} disabled!", this.PLUGIN_NAME, this.VERSION);
    }

    public void onReload() {
        long time = System.currentTimeMillis();
        this.isConfigurationLoaded = MessagesLoader.initialize() && ConfigurationLoader.initialize();
        this.unregisterListeners();
        this.registerListeners();
        SignTypes.initialize();
        if (this.isConfigurationLoaded) {
            Console.info("<green>Plugin {} {} reloaded! ({} ms)", this.PLUGIN_NAME, this.VERSION, System.currentTimeMillis() - time);
        } else {
            Console.warn("Plugin {} {} is not reloaded! There was an error in the console above!", this.PLUGIN_NAME, this.VERSION);
        }
    }

    private void registerMetrics() {
        Metrics metrics = new Metrics(this, 26326);
        metrics.addCustomChart(new Metrics.AdvancedPie("protection_plugins_used", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            boolean hasAnyProtectionPlugin = false;
            for (ProtectionPlugins.ProtectionPlugin plugin : ProtectionPlugins.plugins()) {
                hasAnyProtectionPlugin = true;
                valueMap.put(plugin.name, 1);
            }
            if (!hasAnyProtectionPlugin) {
                valueMap.put("<none>", 1);
            }
            return valueMap;
        }));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ExplodeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GrowListener(), (Plugin)this);
    }

    private void unregisterListeners() {
        HandlerList.unregisterAll((Plugin)this);
    }

    public static InteractiveSigns getInstance() {
        return INSTANCE;
    }

    public static FoliaLib getFoliaInstance() {
        return FOLIA_INSTANCE;
    }

    public static String getPluginName() {
        return InteractiveSigns.INSTANCE.PLUGIN_NAME;
    }

    public static String getVersion() {
        return InteractiveSigns.INSTANCE.VERSION;
    }

    public static String getAuthor() {
        return InteractiveSigns.INSTANCE.AUTHOR;
    }
}

