/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns;

import at.pcgamingfreaks.Minepacks.Bukkit.API.MinepacksPlugin;
import com.fastasyncworldedit.core.configuration.Settings;
import com.sk89q.worldedit.WorldEdit;
import java.io.File;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.InteractiveSigns;
import me.vovari2.interactivesigns.listeners.WorldEditListener;
import me.vovari2.interactivesigns.utils.FileUtils;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public enum Plugins {
    CoreProtect,
    PlaceholderAPI,
    FastAsyncWorldEdit,
    WorldEdit,
    Minepacks;

    private Plugin plugin;
    private boolean loaded = false;
    private boolean enabled = false;

    static void load() {
        PluginManager manager = InteractiveSigns.getInstance().getServer().getPluginManager();
        for (Plugins plugin : Plugins.values()) {
            plugin.plugin = manager.getPlugin(plugin.name());
            if (plugin.plugin == null) continue;
            plugin.loadInside();
        }
    }

    static void enable() {
        if (Plugins.CoreProtect.loaded) {
            Plugin plugin = Plugins.CoreProtect.plugin;
            if (!(plugin instanceof CoreProtect)) {
                return;
            }
            CoreProtect coreProtect = (CoreProtect)plugin;
            CoreProtectAPI api = coreProtect.getAPI();
            if (!api.isEnabled()) {
                Console.error("CoreProtect plugin API is not enabled!", new Object[0]);
                return;
            }
            if (api.APIVersion() < 10) {
                Console.error("CoreProtect plugin unsupported version v%s (needed v22.4+)!".formatted(coreProtect.getDescription().getVersion()), new Object[0]);
                return;
            }
            if (Plugins.FastAsyncWorldEdit.loaded) {
                Plugins.addAllowedPluginInFAWE("net.coreprotect.worldedit.CoreProtectLogger");
            }
            CoreProtect.enableInside();
        }
        if (Plugins.PlaceholderAPI.loaded) {
            PlaceholderAPI.enableInside();
        }
        if (Plugins.FastAsyncWorldEdit.loaded) {
            Plugins.addAllowedPluginInFAWE("me.vovari2.interactivesigns.listeners.WorldEditListener");
            FastAsyncWorldEdit.enableInside();
        }
        if (Plugins.WorldEdit.loaded) {
            com.sk89q.worldedit.WorldEdit.getInstance().getEventBus().register((Object)new WorldEditListener());
            WorldEdit.enableInside();
        }
        if (Plugins.Minepacks.loaded) {
            if (!(Plugins.Minepacks.plugin instanceof MinepacksPlugin)) {
                return;
            }
            Minepacks.enableInside();
        }
    }

    private static void addAllowedPluginInFAWE(@NotNull String classPath) {
        File config = new File(new File(FileUtils.getPluginFolder().getParentFile(), "FastAsyncWorldEdit"), "config.yml");
        Settings.settings().load(config);
        if (!Settings.settings().EXTENT.ALLOWED_PLUGINS.contains(classPath)) {
            Settings.settings().EXTENT.ALLOWED_PLUGINS.add(classPath);
            Settings.settings().save(config);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    void loadInside() {
        this.loaded = true;
        Console.info("Found %s plugin!".formatted(this.name()), new Object[0]);
    }

    void enableInside() {
        this.enabled = true;
        Console.info("Connected %s plugin!".formatted(this.name()), new Object[0]);
    }
}

