/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns;

import com.bekvon.bukkit.residence.api.ResidenceApi;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.griefdefender.api.Core;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.TrustTypes;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionType;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import me.angeschossen.chestprotect.api.ChestProtectAPI;
import me.angeschossen.chestprotect.api.protection.block.BlockProtection;
import me.angeschossen.chestprotect.api.protection.world.ProtectionWorld;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.enums.FlagTarget;
import me.angeschossen.lands.api.flags.enums.RoleFlagCategory;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.LandWorld;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.InteractiveSigns;
import me.vovari2.interactivesigns.loaders.types.ConfigurationLoader;
import net.william278.huskclaims.api.BukkitHuskClaimsAPI;
import net.william278.huskclaims.api.HuskClaimsAPI;
import net.william278.huskclaims.claim.Claim;
import net.william278.huskclaims.libraries.cloplib.operation.OperationType;
import net.william278.huskclaims.position.Position;
import net.william278.huskclaims.trust.TrustLevel;
import net.william278.huskclaims.user.OnlineUser;
import net.william278.huskclaims.user.User;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ProtectionPlugins {
    private static List<ProtectionPlugin> plugins;

    public static void load() {
        plugins = new LinkedList<ProtectionPlugin>();
        ProtectionPlugins.addPlugin(WorldGuardProtectionPlugin.class, "WorldGuard");
        ProtectionPlugins.addPlugin(LandsProtectionPlugin.class, "Lands");
        ProtectionPlugins.addPlugin(ResidenceProtectionPlugin.class, "Residence");
        ProtectionPlugins.addPlugin(GriefPreventionProtectionPlugin.class, "GriefPrevention");
        ProtectionPlugins.addPlugin(SuperiorSkyblock2ProtectionPlugin.class, "SuperiorSkyblock2");
        ProtectionPlugins.addPlugin(ChestProtectProtectionPlugin.class, "ChestProtect");
        ProtectionPlugins.addPlugin(GriefDefenderProtectionPlugin.class, "GriefDefender");
    }

    public static void initialize() {
        ProtectionPlugins.addPlugin(HuskClaimsProtectionPlugin.class, "HuskClaims");
    }

    private static void addPlugin(Class<? extends ProtectionPlugin> plugin, String name) {
        if (!ProtectionPlugins.isEnabledPlugin(name)) {
            return;
        }
        boolean isFullEnabled = true;
        try {
            plugins.add(plugin.getDeclaredConstructor(String.class).newInstance(name));
        }
        catch (Exception ignored) {
            isFullEnabled = false;
        }
        if (isFullEnabled) {
            Console.info("Found %s plugin! Plugin support is fully enabled!".formatted(name), new Object[0]);
        } else {
            Console.warn("Found %s plugin! Plugin support is not enabled due to a bug!".formatted(name), new Object[0]);
        }
    }

    public static boolean isEnabledPlugin(String name) {
        return InteractiveSigns.getInstance().getServer().getPluginManager().getPlugin(name) != null;
    }

    public static boolean canInteractWithSign(Player player, Location location) {
        boolean canInteract = true;
        for (ProtectionPlugin plugin : plugins) {
            if (plugin.canInteractWithSign(player, location)) continue;
            canInteract = false;
        }
        return canInteract;
    }

    static List<ProtectionPlugin> plugins() {
        return plugins;
    }

    private static class WorldGuardProtectionPlugin
    extends ProtectionPlugin {
        private final StateFlag USES_ITEMS_ON_SIGNS;

        WorldGuardProtectionPlugin(@NotNull String name) {
            super(name);
            FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
            Flag flag = registry.get("uses-items-on-signs");
            if (flag == null) {
                this.USES_ITEMS_ON_SIGNS = new StateFlag("uses-items-on-signs", false);
                registry.register((Flag)this.USES_ITEMS_ON_SIGNS);
            } else {
                this.USES_ITEMS_ON_SIGNS = (StateFlag)flag;
            }
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            World world = BukkitAdapter.adapt((org.bukkit.World)location.getWorld());
            if (!WorldGuardPlugin.inst().getConfigManager().get((World)world).useRegions) {
                return true;
            }
            RegionManager container = WorldGuard.getInstance().getPlatform().getRegionContainer().get(world);
            if (container == null) {
                return true;
            }
            BlockVector3 blockVector3 = BukkitAdapter.asBlockVector((Location)location);
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            for (ProtectedRegion region : container.getApplicableRegions(blockVector3).getRegions()) {
                if (region.isMember(localPlayer) || StateFlag.State.ALLOW.equals(region.getFlag((Flag)this.USES_ITEMS_ON_SIGNS)) || region.getType().equals((Object)RegionType.GLOBAL) || player.isOp()) continue;
                return false;
            }
            return true;
        }
    }

    private static class LandsProtectionPlugin
    extends ProtectionPlugin {
        private final LandsIntegration instance = LandsIntegration.of((Plugin)InteractiveSigns.getInstance());
        private final RoleFlag flag = RoleFlag.of((LandsIntegration)this.instance, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)ConfigurationLoader.LANDS_FLAG_ID);

        LandsProtectionPlugin(@NotNull String name) {
            super(name);
            ((RoleFlag)((RoleFlag)this.flag.setDisplayName(ConfigurationLoader.LANDS_FLAG_NAME)).setIcon(new ItemStack(ConfigurationLoader.LANDS_FLAG_MATERIAL))).setDescription(ConfigurationLoader.LANDS_FLAG_DESCRIPTION);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            LandWorld world = this.instance.getWorld(location.getWorld());
            if (world == null) {
                return true;
            }
            return world.hasRoleFlag(player.getUniqueId(), location, this.flag);
        }
    }

    private static class ResidenceProtectionPlugin
    extends ProtectionPlugin {
        ResidenceProtectionPlugin(@NotNull String name) {
            super(name);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            ClaimedResidence res = ResidenceApi.getResidenceManager().getByLoc(location);
            if (res == null) {
                return true;
            }
            return res.getPermissions().playerHas(player, Flags.container, true);
        }
    }

    private static class GriefPreventionProtectionPlugin
    extends ProtectionPlugin {
        GriefPreventionProtectionPlugin(@NotNull String name) {
            super(name);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            return GriefPrevention.instance.allowBuild(player, location) == null;
        }
    }

    private static class SuperiorSkyblock2ProtectionPlugin
    extends ProtectionPlugin {
        SuperiorSkyblock2ProtectionPlugin(@NotNull String name) {
            super(name);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            org.bukkit.World world = location.getWorld();
            if (world == null) {
                return false;
            }
            if (!world.getName().equals("superiorworld")) {
                return true;
            }
            location.getWorld().getName();
            Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
            if (island == null) {
                return false;
            }
            return island.isMember(SuperiorSkyblockAPI.getPlayer((Player)player));
        }
    }

    private static class ChestProtectProtectionPlugin
    extends ProtectionPlugin {
        private final ChestProtectAPI instance = ChestProtectAPI.getInstance();

        ChestProtectProtectionPlugin(@NotNull String name) {
            super(name);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            ProtectionWorld world = this.instance.getProtectionWorld(location.getWorld());
            if (world == null) {
                return true;
            }
            BlockProtection block = world.getBlockProtection(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            if (block == null) {
                return true;
            }
            return block.getTrusted().contains(player.getUniqueId());
        }
    }

    private static class GriefDefenderProtectionPlugin
    extends ProtectionPlugin {
        private final Core instance = GriefDefender.getCore();

        GriefDefenderProtectionPlugin(@NotNull String name) {
            super(name);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            com.griefdefender.api.claim.Claim claim = this.instance.getClaimAt((Object)location);
            if (claim == null) {
                return false;
            }
            if (claim.isWilderness()) {
                return false;
            }
            return claim.canUseBlock(null, (Object)location, this.instance.getUser(player.getUniqueId()), TrustTypes.BUILDER);
        }
    }

    private static class HuskClaimsProtectionPlugin
    extends ProtectionPlugin {
        private final String ITEMS_ON_SIGNS = ConfigurationLoader.HUSKCLAIMS_FLAG_ID;

        HuskClaimsProtectionPlugin(@NotNull String name) {
            super(name);
        }

        @Override
        public boolean canInteractWithSign(Player player, Location location) {
            try {
                Position position = BukkitHuskClaimsAPI.getInstance().getPosition(location);
                Claim claim = (Claim)BukkitHuskClaimsAPI.getInstance().getClaimAt(position).orElseThrow();
                try {
                    OnlineUser user = BukkitHuskClaimsAPI.getInstance().getOnlineUser(player);
                    for (OperationType operation : ((TrustLevel)claim.getUserTrustLevel((User)user, HuskClaimsAPI.getInstance().getPlugin()).orElseThrow()).getFlags()) {
                        if (!this.ITEMS_ON_SIGNS.equals(operation.getKey().value())) continue;
                        return true;
                    }
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
            catch (NoSuchElementException e) {
                return true;
            }
            return false;
        }
    }

    static abstract class ProtectionPlugin {
        protected final String name;

        protected ProtectionPlugin(String name) {
            this.name = name;
        }

        public abstract boolean canInteractWithSign(Player var1, Location var2);
    }
}

