/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.listeners;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collection;
import java.util.Set;
import me.vovari2.interactivesigns.Timer;
import me.vovari2.interactivesigns.utils.NamespacedKeyUtils;
import org.bukkit.Location;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;

public class WorldEditListener {
    @Subscribe
    public void onEditSessionChange(EditSessionEvent event) {
        if (event.getWorld() == null || !event.getStage().equals((Object)EditSession.Stage.BEFORE_HISTORY)) {
            return;
        }
        event.setExtent((Extent)new SignExtent(event.getExtent(), BukkitAdapter.adapt((World)event.getWorld())));
    }

    private static class SignExtent
    extends AbstractDelegateExtent {
        private final org.bukkit.World world;

        public SignExtent(@NotNull Extent extent, @NotNull org.bukkit.World world) {
            super(extent);
            this.world = world;
        }

        public void removeItemDisplayFromSign(@NotNull Region region) {
            Vector3 dimensions;
            Vector3 minimum = region.getMinimumPoint().toVector3();
            Vector3 center = minimum.add(dimensions = region.getDimensions().toVector3().divide(2.0));
            Collection list = this.world.getNearbyEntities(BukkitAdapter.adapt((org.bukkit.World)this.world, (Vector3)center), dimensions.x(), dimensions.y(), dimensions.z(), entity -> {
                if (!(entity instanceof ItemDisplay)) {
                    return false;
                }
                ItemDisplay display = (ItemDisplay)entity;
                return display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSignOld()) || display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSign(Side.FRONT.name())) || display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSign(Side.BACK.name()));
            });
            if (!list.isEmpty()) {
                list.forEach(entity -> {
                    if (!(entity instanceof ItemDisplay)) {
                        return;
                    }
                    ItemDisplay display = (ItemDisplay)entity;
                    this.world.dropItem(display.getLocation(), display.getItemStack());
                    display.remove();
                });
            }
        }

        public void removeItemDisplayFromSign(@NotNull Location location) {
            Collection list = location.getWorld().getNearbyEntitiesByType(ItemDisplay.class, location, 0.1, display -> {
                PersistentDataContainer container = display.getPersistentDataContainer();
                return container.has(NamespacedKeyUtils.forItemOnSignOld()) || container.has(NamespacedKeyUtils.forItemOnSign(Side.FRONT.name())) || container.has(NamespacedKeyUtils.forItemOnSign(Side.BACK.name()));
            });
            if (!list.isEmpty()) {
                list.forEach(display -> {
                    this.world.dropItem(display.getLocation(), display.getItemStack());
                    display.remove();
                });
            }
        }

        public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 pos, T block) throws WorldEditException {
            Timer.wait(0, () -> this.removeItemDisplayFromSign(BukkitAdapter.adapt((org.bukkit.World)this.world, (BlockVector3)pos).add(0.5, 0.5, 0.5)));
            return super.setBlock(pos, block);
        }

        public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T block) throws WorldEditException {
            Timer.wait(0, () -> this.removeItemDisplayFromSign(new Location(this.world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)));
            return super.setBlock(x, y, z, block);
        }

        public <B extends BlockStateHolder<B>> int setBlocks(Region region, B block) throws MaxChangedBlocksException {
            Timer.wait(0, () -> region.forEach(pos -> this.removeItemDisplayFromSign(BukkitAdapter.adapt((org.bukkit.World)this.world, (BlockVector3)pos).add(0.5, 0.5, 0.5))));
            return super.setBlocks(region, block);
        }

        public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
            Timer.wait(0, () -> this.removeItemDisplayFromSign(region));
            return super.setBlocks(region, pattern);
        }

        public <B extends BlockStateHolder<B>> int replaceBlocks(Region region, Set<BaseBlock> filter, B replacement) throws MaxChangedBlocksException {
            Timer.wait(0, () -> this.removeItemDisplayFromSign(region));
            return super.replaceBlocks(region, filter, replacement);
        }

        public int replaceBlocks(Region region, Set<BaseBlock> filter, Pattern pattern) throws MaxChangedBlocksException {
            Timer.wait(0, () -> this.removeItemDisplayFromSign(region));
            return super.replaceBlocks(region, filter, pattern);
        }

        public int replaceBlocks(Region region, Mask mask, Pattern pattern) throws MaxChangedBlocksException {
            Timer.wait(0, () -> this.removeItemDisplayFromSign(region));
            return super.replaceBlocks(region, mask, pattern);
        }

        public int setBlocks(Set<BlockVector3> vset, Pattern pattern) {
            Timer.wait(10, () -> vset.forEach(pos -> this.removeItemDisplayFromSign(BukkitAdapter.adapt((org.bukkit.World)this.world, (BlockVector3)pos).add(0.5, 0.5, 0.5))));
            return super.setBlocks(vset, pattern);
        }
    }
}

