/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.loaders.types;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.loaders.Loader;
import me.vovari2.interactivesigns.utils.FileUtils;
import org.bukkit.Material;

public class ConfigurationLoader
extends Loader {
    public static boolean ENABLE_ITEMS_VOLUME;
    public static List<Material> DISALLOW_SIGN_ITEM_PLACEMENT;
    public static boolean PLAYER_NEED_TO_HAVE_PERMISSION_TO_USE_SIGNS;
    public static String PERMISSION_CAN_USE_SIGNS;
    public static String HUSKCLAIMS_FLAG_ID;
    public static String LANDS_FLAG_ID;
    public static String LANDS_FLAG_NAME;
    public static Material LANDS_FLAG_MATERIAL;
    public static String LANDS_FLAG_DESCRIPTION;

    public static boolean initialize() {
        try {
            new ConfigurationLoader("config.yml");
            return true;
        }
        catch (Exception e) {
            Console.error("Error loading configuration: " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    private ConfigurationLoader(String resourcePath) throws Exception {
        FileUtils.createResourceFileInFolder(resourcePath);
        this.configuration = FileUtils.getContentFromYamlFile(FileUtils.getPluginFolder(), resourcePath);
        ENABLE_ITEMS_VOLUME = this.getBoolean("enable_items_volume", false);
        DISALLOW_SIGN_ITEM_PLACEMENT = this.getMaterialList("blacklist_of_items");
        PLAYER_NEED_TO_HAVE_PERMISSION_TO_USE_SIGNS = this.getBoolean("player_need_to_have_permission_to_use_signs");
        PERMISSION_CAN_USE_SIGNS = this.getString("permission_can_use_signs");
        HUSKCLAIMS_FLAG_ID = this.getString("huskclaims.flag_id");
        LANDS_FLAG_ID = this.configuration.getString("lands.flag_id");
        LANDS_FLAG_NAME = this.getString("lands.flag_name");
        LANDS_FLAG_MATERIAL = this.getMaterial("lands.flag_material", Material.STONE);
        LANDS_FLAG_DESCRIPTION = this.getString("lands.flag_description");
    }

    private List<Material> getMaterialList(String path) throws Exception {
        Iterator iterator = this.configuration.getStringList(path).iterator();
        LinkedList<Material> materialList = new LinkedList<Material>();
        int i = 1;
        while (iterator.hasNext()) {
            materialList.add(this.getMaterial((String)iterator.next(), "%s.%s".formatted(path, String.valueOf(i))));
            ++i;
        }
        return materialList;
    }
}

