/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.loaders.types;

import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import me.vovari2.interactivesigns.Console;
import me.vovari2.interactivesigns.loaders.Loader;
import me.vovari2.interactivesigns.messages.Messages;
import me.vovari2.interactivesigns.messages.types.ActionbarMessage;
import me.vovari2.interactivesigns.messages.types.BossbarMessage;
import me.vovari2.interactivesigns.messages.types.ChatMessage;
import me.vovari2.interactivesigns.messages.types.TitleMessage;
import me.vovari2.interactivesigns.utils.FileUtils;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.title.Title;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesLoader
extends Loader {
    public static boolean initialize() {
        try {
            new MessagesLoader("messages.yml");
            return true;
        }
        catch (Exception e) {
            Console.error("Error loading messages: " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    private MessagesLoader(@NotNull String fileName) throws Exception {
        File pluginFolder = FileUtils.getPluginFolder();
        File file = new File(pluginFolder, fileName);
        if (!file.exists()) {
            this.configuration = new YamlConfiguration();
            for (Messages message : Messages.values()) {
                this.configuration.set(message.name().replaceAll("_", "-").toLowerCase(), (Object)message.string());
            }
            FileUtils.createFolder(pluginFolder);
            FileUtils.createFileInFolder(pluginFolder, file);
            FileUtils.setContentInYamlFile(pluginFolder, fileName, (FileConfiguration)this.configuration);
        } else {
            this.configuration = FileUtils.getContentFromYamlFile(pluginFolder, fileName);
            for (Messages object : Messages.values()) {
                String path = object.name().replaceAll("_", "-").toLowerCase();
                ConfigurationSection section = this.configuration.getConfigurationSection(path);
                if (section == null) {
                    object.set(new ChatMessage(this.getStringFromSection(path), null));
                    continue;
                }
                String message = this.getStringFromSection("%s.message".formatted(path));
                net.kyori.adventure.sound.Sound sound = this.getSound("%s.sound".formatted(path));
                object.set(switch (this.getString("%s.type".formatted(path)).toUpperCase()) {
                    case "ACTIONBAR" -> new ActionbarMessage(message, sound);
                    case "BOSSBAR" -> {
                        BossBar.Color color = this.getBossbarColor("%s.color".formatted(path), BossBar.Color.YELLOW);
                        BossBar.Overlay overlay = this.getBossbarOverlay("%s.overlay".formatted(path), BossBar.Overlay.NOTCHED_6);
                        yield new BossbarMessage(message, sound, color, overlay, this.configuration.getInt("%s.stay-time", 100));
                    }
                    case "TITLE" -> {
                        String subtitle = this.getString("%s.subtitle".formatted(path), "");
                        Duration fadeIn = this.getDuration("%s.fade-in".formatted(path), Duration.of(500L, ChronoUnit.MILLIS));
                        Duration stay = this.getDuration("%s.stay".formatted(path), Duration.of(3500L, ChronoUnit.MILLIS));
                        Duration fadeOut = this.getDuration("%s.fade-out".formatted(path), Duration.of(1000L, ChronoUnit.MILLIS));
                        yield new TitleMessage(message, sound, subtitle, Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut));
                    }
                    default -> new ChatMessage(message, sound);
                });
            }
        }
    }

    @Nullable
    private String getStringFromSection(@NotNull String path) throws Exception {
        List messages = this.configuration.getStringList(path);
        return messages.isEmpty() ? super.getString(path, null) : String.join((CharSequence)"\n", messages);
    }

    @Nullable
    private net.kyori.adventure.sound.Sound getSound(@NotNull String path) throws Exception {
        ConfigurationSection section = this.configuration.getConfigurationSection(path);
        if (section == null) {
            return null;
        }
        return net.kyori.adventure.sound.Sound.sound((Sound.Type)this.toSound(this.getString("%s.name".formatted(path)), "%s.name".formatted(path)), (Sound.Source)Sound.Source.PLAYER, (float)((float)this.configuration.getDouble("%s.volume".formatted(path), 1.0)), (float)((float)this.configuration.getDouble("%s.pitch".formatted(path), 1.0)));
    }

    @NotNull
    private Sound toSound(@NotNull String value, @NotNull String path) throws Exception {
        try {
            return Sound.valueOf((String)value.toUpperCase());
        }
        catch (Exception e) {
            throw new Exception("<red>Value '%s' must be a sound!".formatted(path));
        }
    }

    @NotNull
    private BossBar.Color getBossbarColor(@NotNull String path, @NotNull BossBar.Color def) {
        try {
            return BossBar.Color.valueOf((String)this.getString(path).toUpperCase());
        }
        catch (Exception e) {
            return def;
        }
    }

    @NotNull
    private BossBar.Overlay getBossbarOverlay(@NotNull String path, @NotNull BossBar.Overlay def) {
        try {
            return BossBar.Overlay.valueOf((String)this.getString(path).toUpperCase());
        }
        catch (Exception e) {
            return def;
        }
    }

    @NotNull
    private Duration getDuration(@NotNull String path, @NotNull Duration def) throws Exception {
        String strValue = this.configuration.getString(path);
        if (strValue == null) {
            return def;
        }
        if (!strValue.matches("^\\d+[stm]$")) {
            throw new Exception("<red>Value '%s' has invalid format!".formatted(path));
        }
        int intValue = Integer.parseInt(strValue.substring(0, strValue.length() - 1));
        return Duration.of(intValue *= (switch (strValue.substring(strValue.length() - 1)) {
            case "s" -> 1000;
            case "t" -> 50;
            default -> 1;
        }), ChronoUnit.MILLIS);
    }
}

