/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.messages;

import me.vovari2.interactivesigns.utils.PlaceholderUtils;
import me.vovari2.interactivesigns.utils.TextUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Message {
    protected final String message;
    protected final Sound sound;

    protected Message(@Nullable String message, @Nullable Sound sound) {
        this.message = message == null ? "" : message;
        this.sound = sound;
    }

    @NotNull
    public String string() {
        return this.message;
    }

    @NotNull
    public Component component() {
        return TextUtils.toComponent(this.message);
    }

    @NotNull
    public String string(@NotNull Player player) {
        return PlaceholderUtils.replacePlaceholders(player, this.message);
    }

    @NotNull
    public Component component(@NotNull Player player) {
        return TextUtils.toComponent(this.string(player));
    }

    private void playSound(@NotNull Audience audience) {
        if (this.sound != null) {
            audience.playSound(this.sound);
        }
    }

    protected abstract void sendInside(@NotNull Audience var1);

    public void send(@NotNull Audience audience) {
        this.playSound(audience);
        if (this.message.isEmpty()) {
            return;
        }
        this.sendInside(audience);
    }

    @NotNull
    protected abstract Message replaceInside(@NotNull String var1, @NotNull String var2);

    @NotNull
    public Message replace(@NotNull String placeholder, @NotNull String replacement) {
        return this.replaceInside(placeholder, replacement);
    }

    @NotNull
    public Message replace(@NotNull String placeholder, int replacement) {
        return this.replaceInside(placeholder, String.valueOf(replacement));
    }

    @NotNull
    public Message replace(@NotNull String placeholder, long replacement) {
        return this.replaceInside(placeholder, String.valueOf(replacement));
    }
}

