/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.messages.types;

import java.util.HashMap;
import java.util.UUID;
import me.vovari2.interactivesigns.Timer;
import me.vovari2.interactivesigns.messages.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossbarMessage
extends Message {
    private final BossBar.Color color;
    private final BossBar.Overlay overlay;
    private final int stayTime;

    public BossbarMessage(@Nullable String message, @Nullable Sound sound, @NotNull BossBar.Color color, @NotNull BossBar.Overlay overlay, int stayTime) {
        super(message, sound);
        this.color = color;
        this.overlay = overlay;
        this.stayTime = stayTime;
    }

    @Override
    protected void sendInside(@NotNull Audience audience) {
        if (audience instanceof Player) {
            Player player = (Player)audience;
            BossBar bossBar = BossBar.bossBar((Component)this.component(player), (float)1.0f, (BossBar.Color)this.color, (BossBar.Overlay)this.overlay);
            player.showBossBar(bossBar);
            SendBossbarMessages.start(player.getUniqueId(), () -> player.hideBossBar(bossBar));
        } else {
            audience.sendMessage(this.component());
        }
    }

    @Override
    @NotNull
    protected Message replaceInside(@NotNull String placeholder, @NotNull String replacement) {
        return new BossbarMessage(this.message.replaceAll("<%" + placeholder + "%>", replacement), this.sound, this.color, this.overlay, this.stayTime);
    }

    public static class SendBossbarMessages {
        private static final HashMap<UUID, Timer> timers = new HashMap();

        public static void start(@NotNull UUID player, @NotNull Timer.WaitOperation operation) {
            if (timers.containsKey(player)) {
                Timer timer = timers.get(player);
                timer.runnable().run();
                timer.task().cancel();
            }
            timers.put(player, Timer.wait(2000, operation));
        }
    }
}

