/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.sign;

import com.destroystokyo.paper.MaterialSetTag;
import java.util.HashMap;
import me.vovari2.interactivesigns.loaders.types.ConfigurationLoader;
import me.vovari2.interactivesigns.sign.MaterialType;
import me.vovari2.interactivesigns.sign.SignType;
import me.vovari2.interactivesigns.sign.types.HangingSign2D;
import me.vovari2.interactivesigns.sign.types.HangingSign3D;
import me.vovari2.interactivesigns.sign.types.StandingSign2D;
import me.vovari2.interactivesigns.sign.types.StandingSign3D;
import me.vovari2.interactivesigns.sign.types.WallSign2D;
import me.vovari2.interactivesigns.sign.types.WallSign3D;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.sign.Side;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;

public enum SignTypes {
    STANDING_SIGN,
    WALL_SIGN,
    HANGING_SIGN;

    private static HashMap<SignTypes, SignType> types;

    public static void initialize() {
        types = new HashMap();
        boolean isThreeDimensional = ConfigurationLoader.ENABLE_ITEMS_VOLUME;
        types.put(STANDING_SIGN, isThreeDimensional ? new StandingSign3D() : new StandingSign2D());
        types.put(WALL_SIGN, isThreeDimensional ? new WallSign3D() : new WallSign2D());
        types.put(HANGING_SIGN, isThreeDimensional ? new HangingSign3D() : new HangingSign2D());
    }

    @NotNull
    public static Transformation getTransformation(Side side, Material signMaterial, Material placedMaterial) {
        return types.get((Object)SignTypes.getType(signMaterial)).getSignTransformation(side, MaterialType.getType(placedMaterial)).getTransformation();
    }

    @NotNull
    private static SignTypes getType(Material material) {
        if (MaterialSetTag.WALL_SIGNS.isTagged((Keyed)material)) {
            return WALL_SIGN;
        }
        if (MaterialSetTag.WALL_HANGING_SIGNS.isTagged((Keyed)material) || MaterialSetTag.CEILING_HANGING_SIGNS.isTagged((Keyed)material)) {
            return HANGING_SIGN;
        }
        return STANDING_SIGN;
    }

    @NotNull
    public static BlockFace getSignFace(@NotNull BlockData blockData) {
        return SignTypes.isWall(blockData.getMaterial()) ? ((Directional)blockData).getFacing() : ((Rotatable)blockData).getRotation().getOppositeFace();
    }

    public static boolean isWall(@NotNull Material material) {
        return MaterialSetTag.WALL_HANGING_SIGNS.isTagged((Keyed)material) || MaterialSetTag.WALL_SIGNS.isTagged((Keyed)material);
    }
}

