/*
 * Decompiled with CFR 0.152.
 */
package me.vovari2.interactivesigns.utils;

import java.util.Collection;
import me.vovari2.interactivesigns.utils.NamespacedKeyUtils;
import org.bukkit.Location;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class ItemDisplayUtils {
    @Nullable
    public static ItemDisplay getItemDisplayOnSign(Location location, Side side) {
        Collection list = location.getWorld().getNearbyEntitiesByType(ItemDisplay.class, location, 0.1, display -> display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSign(side.name())));
        if (list.isEmpty()) {
            return null;
        }
        return (ItemDisplay)list.iterator().next();
    }

    public static void dropItemFromDisplay(Location location, Side side) {
        ItemDisplay display = ItemDisplayUtils.getItemDisplayOnSign(location, side);
        if (display == null) {
            return;
        }
        display.remove();
        location.getWorld().dropItemNaturally(location, display.getItemStack());
    }

    @Nullable
    public static ItemDisplay getItemDisplayOnSignOld(Location location) {
        Collection list = location.getWorld().getNearbyEntitiesByType(ItemDisplay.class, location, 0.1, display -> display.getPersistentDataContainer().has(NamespacedKeyUtils.forItemOnSignOld()));
        if (list.isEmpty()) {
            return null;
        }
        return (ItemDisplay)list.iterator().next();
    }

    public static void convertFromOldDisplay(ItemDisplay display) {
        if (display == null) {
            return;
        }
        PersistentDataContainer container = display.getPersistentDataContainer();
        String side = (String)container.get(NamespacedKeyUtils.forItemOnSignOld(), PersistentDataType.STRING);
        if (side == null) {
            return;
        }
        container.remove(NamespacedKeyUtils.forItemOnSignOld());
        container.set(NamespacedKeyUtils.forItemOnSign(side), PersistentDataType.BOOLEAN, (Object)false);
    }
}

