/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.client;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.UUID;
import net.arcana.friendsforlife.Net;
import net.arcana.friendsforlife.Packets;
import net.arcana.friendsforlife.client.ClientHomeBlock;
import net.arcana.friendsforlife.client.ClientOcarinaRegistry;
import net.arcana.friendsforlife.client.ClientPetData;
import net.arcana.friendsforlife.client.ClientPetList;
import net.arcana.friendsforlife.client.HomeBlockRenderer;
import net.arcana.friendsforlife.client.RosterScreen;
import net.arcana.friendsforlife.homeblock.HomeBlockUpdateEvents;
import net.arcana.friendsforlife.packets.HomeUpdatePacket;
import net.arcana.friendsforlife.packets.OcarinaUpdatePacket;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ClientInit
implements ClientModInitializer {
    private static class_304 openBookKey;

    public void onInitializeClient() {
        HomeBlockRenderer.register();
        openBookKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.friendsforlife.open_book", class_3675.class_307.field_1668, 80, "category.friendsforlife.keys"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_310 mc;
            if (openBookKey.method_1436() && (mc = class_310.method_1551()) != null) {
                mc.method_1507((class_437)new RosterScreen());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Packets.RESPONSE_PET_TRACKER, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            ArrayList<ClientPetData> pets = new ArrayList<ClientPetData>();
            for (int i = 0; i < size; ++i) {
                UUID uuid = buf.method_10790();
                String entityTypeId = buf.method_10800(Short.MAX_VALUE);
                class_2487 nbt = buf.method_10798();
                String name = buf.method_10800(Short.MAX_VALUE);
                String position = buf.method_10800(Short.MAX_VALUE);
                long homePosLong = buf.readLong();
                class_2338 homePosition = null;
                if (homePosLong != 0L) {
                    homePosition = class_2338.method_10092((long)homePosLong);
                }
                class_2960 homeDimension = null;
                String homeDimStr = buf.method_10800(Short.MAX_VALUE);
                if (!homeDimStr.isEmpty()) {
                    homeDimension = new class_2960(homeDimStr);
                }
                pets.add(new ClientPetData(uuid, entityTypeId, nbt, name, position, homePosition, homeDimension));
            }
            client.execute(() -> ClientPetList.setPets(pets));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Packets.RESPONSE_PET_UPDATE, (client, handler, buf, responseSender) -> {
            ArrayList<PetUpdate> updates = new ArrayList<PetUpdate>();
            while (buf.isReadable()) {
                UUID petUuid = buf.method_10790();
                String name = buf.method_19772();
                class_2338 pos = buf.method_10811();
                updates.add(new PetUpdate(petUuid, name, pos));
            }
            client.execute(() -> {
                for (PetUpdate update : updates) {
                    ClientPetData pet = ClientPetList.getPet(update.petUuid());
                    if (pet == null) continue;
                    if (!pet.name.isEmpty()) {
                        pet.name = update.name();
                    }
                    pet.position = update.pos().method_23854();
                }
            });
        });
        Net.CHANNEL.registerClientbound(HomeUpdatePacket.class, (packet, content) -> class_310.method_1551().execute(() -> {
            class_5321 dim = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)packet.dimId());
            HomeBlockUpdateEvents.fire(class_310.method_1551().field_1724.method_5667(), packet.pos(), (class_5321<class_1937>)dim);
        }));
        Net.CHANNEL.registerClientbound(OcarinaUpdatePacket.class, (packet, context) -> class_310.method_1551().execute(() -> {
            UUID ocarinaId = packet.ocarinaUuid();
            UUID petId = packet.petUuid();
            ClientOcarinaRegistry.set(ocarinaId, petId);
        }));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_2540 ptBuf = new class_2540(Unpooled.buffer());
            ClientPlayNetworking.send((class_2960)Packets.REQUEST_PET_TRACKER, (class_2540)ptBuf);
            ClientHomeBlock.initialize();
            ClientOcarinaRegistry.initialize();
            class_2540 ocRegBuf = new class_2540(Unpooled.buffer());
            ClientPlayNetworking.send((class_2960)Packets.REQUEST_OCARINA_REGISTRY, (class_2540)ocRegBuf);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ClientHomeBlock.reset();
            ClientPetList.reset();
            ClientOcarinaRegistry.clear();
        });
    }

    private record PetUpdate(UUID petUuid, String name, class_2338 pos) {
    }
}

