/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.arcana.friendsforlife.client.ClientPetData;
import net.arcana.friendsforlife.petdatabase.PetListUpdateEvents;
import net.minecraft.class_746;

public class ClientPetList {
    private static final Map<UUID, ClientPetData> pets = new ConcurrentHashMap<UUID, ClientPetData>();
    private static final List<Runnable> listeners = new ArrayList<Runnable>();

    public static void reset() {
        pets.clear();
        listeners.clear();
    }

    public static synchronized void setPets(List<ClientPetData> newPets) {
        pets.clear();
        for (ClientPetData pet : newPets) {
            pets.put(pet.uuid, pet);
        }
        ClientPetList.notifyListeners();
    }

    public static synchronized List<ClientPetData> getAllPets() {
        return List.copyOf(pets.values());
    }

    public static synchronized List<ClientPetData> getAllForPlayer(class_746 player) {
        return List.copyOf(pets.values().stream().filter(pet -> pet.getOwnerUuid().equals(player.method_5667())).toList());
    }

    public static ClientPetData getPet(UUID petUuid) {
        return pets.get(petUuid);
    }

    public static void addListener(Runnable listener) {
        listeners.add(listener);
    }

    public static void removeListener(Runnable listener) {
        listeners.remove(listener);
    }

    private static void notifyListeners() {
        for (Runnable listener : List.copyOf(listeners)) {
            listener.run();
        }
    }

    static {
        PetListUpdateEvents.subscribe((playerUuid, newPetList) -> ClientPetList.setPets(newPetList));
    }
}

