/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.petdatabase;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.arcana.friendsforlife.Net;
import net.arcana.friendsforlife.packets.OcarinaUpdatePacket;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;

public class OcarinaRegistry
extends class_18 {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private final Map<UUID, UUID> ocarinaToPet = new HashMap<UUID, UUID>();

    public static OcarinaRegistry get(MinecraftServer server) {
        class_26 mgr = server.method_3847(class_1937.field_25179).method_17983();
        return (OcarinaRegistry)mgr.method_17924(OcarinaRegistry::fromNbt, OcarinaRegistry::new, "friendsforlife_ocarina_registry");
    }

    public static OcarinaRegistry fromNbt(class_2487 tag) {
        OcarinaRegistry reg = new OcarinaRegistry();
        class_2499 list = tag.method_10554("entries", 10);
        for (class_2520 e : list) {
            class_2487 c = (class_2487)e;
            UUID ocarina = c.method_25926("ocarina");
            UUID pet = c.method_25926("pet");
            reg.ocarinaToPet.put(ocarina, pet);
        }
        return reg;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, UUID> entry : this.ocarinaToPet.entrySet()) {
            class_2487 c = new class_2487();
            c.method_25927("ocarina", entry.getKey());
            c.method_25927("pet", entry.getValue());
            list.add((Object)c);
        }
        tag.method_10566("entries", (class_2520)list);
        return tag;
    }

    public class_2540 serializeList() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(this.ocarinaToPet.size());
        for (Map.Entry<UUID, UUID> entry : this.ocarinaToPet.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10797(entry.getValue());
        }
        return buf;
    }

    public void register(UUID ocarinaUuid, UUID petUuid, MinecraftServer server) {
        this.ocarinaToPet.put(ocarinaUuid, petUuid);
        this.method_80();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(ocarinaUuid);
        buf.method_10797(petUuid);
        Net.CHANNEL.serverHandle(server).send((Record)new OcarinaUpdatePacket(ocarinaUuid, petUuid));
    }

    public void unregisterOcarina(UUID ocarinaUuid, MinecraftServer server) {
        this.ocarinaToPet.remove(ocarinaUuid);
        Net.CHANNEL.serverHandle(server).send((Record)new OcarinaUpdatePacket(ocarinaUuid, null));
        this.method_80();
    }

    public List<UUID> getOcarinasForPet(UUID petUuid) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Map.Entry<UUID, UUID> entry : this.ocarinaToPet.entrySet()) {
            if (!entry.getValue().equals(petUuid)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public UUID getPetForOcarina(UUID ocarinaUuid) {
        return this.ocarinaToPet.get(ocarinaUuid);
    }

    public void unregisterAllForPet(UUID petUuid, MinecraftServer server) {
        ArrayList<UUID> ocarinasToClear = new ArrayList<UUID>();
        for (Map.Entry<UUID, UUID> entry : this.ocarinaToPet.entrySet()) {
            if (!entry.getValue().equals(petUuid)) continue;
            ocarinasToClear.add(entry.getKey());
        }
        for (UUID ocarinaUuid : ocarinasToClear) {
            this.ocarinaToPet.remove(ocarinaUuid);
            Net.CHANNEL.serverHandle(server).send((Record)new OcarinaUpdatePacket(ocarinaUuid, EMPTY_UUID));
        }
        this.method_80();
    }
}

