/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.petdatabase;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.arcana.friendsforlife.ModInit;
import net.arcana.friendsforlife.Packets;
import net.arcana.friendsforlife.petdatabase.PetData;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PetTracker
extends class_18 {
    private final Map<UUID, PetData> tracked = new HashMap<UUID, PetData>();
    private final Set<UUID> recreated = new HashSet<UUID>();

    public void addPet(class_1321 tame, class_3222 player, class_1799 item, long tameTimestamp) {
        ModInit.LOGGER.info("adding new entity to be tracked: " + tame.method_5477());
        if (this.tracked.values().stream().noneMatch(pet -> pet.entityUuid.equals(tame.method_5667()))) {
            class_2487 collar = new class_2487();
            item.method_7953(collar);
            PetData pd = new PetData(tame, (class_1297)player, collar, tameTimestamp);
            this.tracked.put(pd.uuid, pd);
            class_2540 petList = PetTracker.serializePetList(player.method_5682());
            ServerPlayNetworking.send((class_3222)player, (class_2960)Packets.RESPONSE_PET_TRACKER, (class_2540)petList);
        }
    }

    public void removePet(MinecraftServer server, UUID uuid) {
        class_3222 player = server.method_3760().method_14602(this.tracked.get((Object)uuid).ownerUuid);
        PetData petData = this.tracked.get(uuid);
        if (petData != null) {
            petData.onRemoved(server);
        }
        this.tracked.remove(uuid);
        if (player == null) {
            ModInit.LOGGER.error("friendsforlife", (Object)("Could not find player to update pet list for removed pet: " + uuid));
            return;
        }
        class_2540 petList = PetTracker.serializePetList(server);
        ServerPlayNetworking.send((class_3222)player, (class_2960)Packets.RESPONSE_PET_TRACKER, (class_2540)petList);
    }

    public Map<UUID, PetData> getTrackedMap() {
        return this.tracked;
    }

    public Set<UUID> getRecreatedMap() {
        return this.recreated;
    }

    public static PetTracker get(MinecraftServer server) {
        class_26 manager = server.method_30002().method_17983();
        return (PetTracker)manager.method_17924(PetTracker::fromNBT, PetTracker::new, "friends_for_life_tracked_pets");
    }

    public PetData get(UUID uuid) {
        return this.tracked.get(uuid);
    }

    @Nullable
    public PetData getByEntityId(UUID entityUuid) {
        return this.tracked.values().stream().filter(pet -> pet.entityUuid.equals(entityUuid)).findFirst().orElse(null);
    }

    public static List<PetData> getAllForPlayer(class_1657 player) {
        return PetTracker.get((MinecraftServer)player.method_5682()).tracked.values().stream().filter(pet -> pet.ownerUuid.equals(player.method_5667())).toList();
    }

    public static class_2540 serializePetData(PetData pet, MinecraftServer server) {
        class_2540 out = new class_2540(Unpooled.buffer());
        PetTracker.serializePetData(out, pet, server);
        return out;
    }

    private static void serializePetData(class_2540 out, PetData pet, MinecraftServer server) {
        out.method_10797(pet.uuid);
        PetData.PetEntityHandle data = pet.getEntity(server).join();
        if (data != null && data.entity() != null) {
            PetTracker.writeEntityData(out, (class_1297)data.entity(), null);
        } else if (data != null && data.shoulderNbt() != null) {
            PetTracker.writeEntityData(out, null, data.shoulderNbt());
        } else {
            PetTracker.writeEntityData(out, null, pet.getEntityData());
        }
        out.method_10814(pet.position.method_23854());
        out.writeLong(pet.homePosition != null ? pet.homePosition.method_10063() : 0L);
        out.method_10814(pet.homeDimension != null ? pet.homeDimension.method_29177().toString() : "");
    }

    public static class_2540 serializePetList(MinecraftServer server) {
        ArrayList<PetData> pets = new ArrayList<PetData>(PetTracker.get((MinecraftServer)server).tracked.values());
        pets.sort((a, b) -> Long.compare(a.tameTimestamp, b.tameTimestamp));
        class_2540 out = new class_2540(Unpooled.buffer());
        out.writeInt(pets.size());
        for (PetData pet : pets) {
            PetTracker.serializePetData(out, pet, server);
        }
        return out;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 petList = new class_2499();
        for (PetData data : this.tracked.values()) {
            petList.add((Object)data.toNbt());
        }
        nbt.method_10566("pets", (class_2520)petList);
        class_2499 recreatedList = new class_2499();
        for (UUID uuid : this.recreated) {
            class_2487 tag = new class_2487();
            tag.method_25927("uuid", uuid);
            recreatedList.add((Object)tag);
        }
        nbt.method_10566("recreatedPets", (class_2520)recreatedList);
        return nbt;
    }

    public static PetTracker fromNBT(class_2487 nbt) {
        PetTracker tracker = new PetTracker();
        class_2499 petList = nbt.method_10554("pets", 10);
        for (class_2520 e : petList) {
            PetData data = PetData.fromNbt((class_2487)e);
            if (data == null) continue;
            tracker.tracked.put(data.uuid, data);
        }
        class_2499 recreatedList = nbt.method_10554("recreatedPets", 10);
        for (class_2520 e : recreatedList) {
            class_2487 tag = (class_2487)e;
            if (!tag.method_25928("uuid")) continue;
            tracker.recreated.add(tag.method_25926("uuid"));
        }
        return tracker;
    }

    private static void writeEntityData(class_2540 out, class_1297 entity, @Nullable class_2487 nbt) {
        if (entity != null) {
            out.method_10814(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString());
            class_2487 entityNbt = new class_2487();
            entity.method_5662(entityNbt);
            out.method_10794(entityNbt);
            String name = entity.method_16914() ? entity.method_5797().getString() : entity.method_5864().method_5897().getString();
            out.method_10814(name);
        } else if (nbt != null) {
            out.method_10814(nbt.method_10558("id"));
            out.method_10794(nbt);
            String name = nbt.method_10545("CustomName") ? class_2561.class_2562.method_10877((String)nbt.method_10558("CustomName")).getString() : ((class_1299)class_7923.field_41177.method_10223(new class_2960(nbt.method_10558("id")))).method_5897().getString();
            out.method_10814(name);
        }
    }
}

