/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic;

import com.creativemd.itemphysic.EventHandler;
import com.creativemd.itemphysic.EventHandlerClient;
import com.creativemd.itemphysic.config.ItemPhysicConfig;
import com.creativemd.itemphysic.list.BurnListRegistry;
import com.creativemd.itemphysic.list.ExplosionListRegistry;
import com.creativemd.itemphysic.list.FloatListRegistry;
import com.creativemd.itemphysic.list.IgnitingListRegistry;
import com.creativemd.itemphysic.list.SulfuricAcidListRegistry;
import com.creativemd.itemphysic.list.UndestroyableListRegistry;
import com.creativemd.itemphysic.packet.PacketDispatcher;
import com.creativemd.itemphysic.proxy.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="itemphysic", version="1.2.9 kotmatross edition", name="ItemPhysic", guiFactory="com.creativemd.itemphysic.config.ItemPhysicGuiFactory")
public class ItemPhysic {
    public static final String MODID = "itemphysic";
    public static final String NAME = "ItemPhysic";
    public static final String VERSION = "1.2.9 kotmatross edition";
    public static final String CLIENTPROXY = "com.creativemd.itemphysic.proxy.ClientProxy";
    public static final String SERVERPROXY = "com.creativemd.itemphysic.proxy.CommonProxy";
    public static final String VERSION2 = "1.2.9";
    @Mod.Instance(value="itemphysic")
    public static ItemPhysic instance;
    @SidedProxy(clientSide="com.creativemd.itemphysic.proxy.ClientProxy", serverSide="com.creativemd.itemphysic.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;
    public static boolean isHBMLoaded;

    protected static void syncConfig() {
        ItemPhysicConfig.loadGeneralConfig(config);
        ItemPhysicConfig.loadBurnListConfig(config);
        ItemPhysicConfig.loadFloatListConfig(config);
        ItemPhysicConfig.loadExplosionListConfig(config);
        ItemPhysicConfig.loadUndestroyableListConfig(config);
        ItemPhysicConfig.loadSulfuricAcidListConfig(config);
        ItemPhysicConfig.loadIgnitingItemsListConfig(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        ItemPhysic.syncConfig();
        PacketDispatcher.registerPackets();
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = EnumChatFormatting.RED + NAME;
        event.getModMetadata().version = EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + VERSION2;
        event.getModMetadata().credits = EnumChatFormatting.GOLD + "CreativeMD";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(EnumChatFormatting.GOLD + "CreativeMD");
        event.getModMetadata().authorList.add(EnumChatFormatting.RED + "HRudyPlayZ");
        event.getModMetadata().authorList.add(EnumChatFormatting.AQUA + "Kotmatross");
        event.getModMetadata().url = "https://github.com/kotmatross28729/ItemPhysic-Legacy-Unofficial";
        event.getModMetadata().description = EnumChatFormatting.GRAY + "A minecraft mod that adds physics to thrown items.";
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerEvents();
        proxy.init(this);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
            FMLCommonHandler.instance().bus().register((Object)new EventHandlerClient());
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        FMLCommonHandler.instance().bus().register((Object)new EventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"hbm")) {
            isHBMLoaded = true;
        }
        BurnListRegistry.registerDefaults();
        FloatListRegistry.registerDefaults();
        ExplosionListRegistry.registerDefaults();
        UndestroyableListRegistry.registerDefaults();
        if (isHBMLoaded) {
            SulfuricAcidListRegistry.registerDefaults();
        }
        IgnitingListRegistry.registerDefaults();
    }

    static {
        isHBMLoaded = false;
    }
}

