/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.list;

import com.creativemd.itemphysic.config.ItemPhysicConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FloatListRegistry {
    public static List<FloatList> FloatItems = new ArrayList<FloatList>();

    public static void registerDefaults() {
        if (ItemPhysicConfig.floatList != null) {
            for (String itemName : ItemPhysicConfig.floatList) {
                List<String> oredictNames;
                int metadata = 0;
                boolean ignoremeta = false;
                ArrayList<String> liquidsList = new ArrayList<String>();
                liquidsList.add("fluid.tile.water");
                String[] parts = itemName.split(":");
                if (parts.length >= 2) {
                    Item item;
                    String modId = parts[0];
                    String itemNameOnly = parts[1];
                    if (parts.length == 3) {
                        try {
                            metadata = Integer.parseInt(parts[2]);
                        }
                        catch (NumberFormatException e) {
                            ignoremeta = Boolean.parseBoolean(parts[2]);
                        }
                        if (!ignoremeta && metadata == 0) {
                            liquidsList.set(0, parts[2]);
                        }
                    } else if (parts.length > 3) {
                        try {
                            metadata = Integer.parseInt(parts[2]);
                        }
                        catch (NumberFormatException e) {
                            ignoremeta = Boolean.parseBoolean(parts[2]);
                        }
                        liquidsList.addAll(Arrays.asList(parts).subList(3, parts.length));
                    }
                    if ((item = GameRegistry.findItem((String)modId, (String)itemNameOnly)) == null) continue;
                    String[] liquidsArray = liquidsList.toArray(new String[0]);
                    FloatList Item2 = new FloatList(item, metadata, ignoremeta, liquidsArray);
                    FloatItems.add(Item2);
                    continue;
                }
                if (parts.length != 1 || !(oredictNames = Arrays.asList(OreDictionary.getOreNames())).contains(itemName)) continue;
                for (ItemStack oreStack : OreDictionary.getOres((String)itemName)) {
                    FloatList Item3;
                    String[] liquidsArray = liquidsList.toArray(new String[0]);
                    if (oreStack.func_77960_j() == Short.MAX_VALUE) {
                        Item3 = new FloatList(oreStack.func_77973_b(), oreStack.func_77960_j(), true, liquidsArray);
                        FloatItems.add(Item3);
                        continue;
                    }
                    Item3 = new FloatList(oreStack.func_77973_b(), oreStack.func_77960_j(), ignoremeta, liquidsArray);
                    FloatItems.add(Item3);
                }
            }
        }
    }

    public static class FloatList {
        public final Item item;
        public final int metadata;
        public final boolean ignoremeta;
        public final String[] liquids;

        public FloatList(Item item, int metadata, boolean ignoremeta, String[] liquids) {
            this.item = item;
            this.metadata = metadata;
            this.ignoremeta = ignoremeta;
            this.liquids = liquids;
        }
    }
}

