/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.list;

import com.creativemd.itemphysic.config.ItemPhysicConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class IgnitingListRegistry {
    public static List<IgnitingList> IgnitingItems = new ArrayList<IgnitingList>();

    public static void registerDefaults() {
        if (ItemPhysicConfig.ignitingItemsList != null) {
            for (String entry : ItemPhysicConfig.ignitingItemsList) {
                Block block;
                String blockName;
                String modIdBlock;
                int metadataItem = 0;
                boolean ignoremetaItem = false;
                int metadataBlock = 0;
                boolean ignoremetaBlock = false;
                int igniteChance = 10;
                String[] parts = entry.split(":");
                if (parts.length > 4) {
                    String itemName;
                    String modIdItem;
                    if (parts.length == 5) {
                        modIdItem = parts[0];
                        itemName = parts[1];
                        modIdBlock = parts[2];
                        blockName = parts[3];
                        try {
                            igniteChance = Integer.parseInt(parts[4]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (parts.length == 6) {
                        modIdItem = parts[0];
                        itemName = parts[1];
                        try {
                            metadataItem = Integer.parseInt(parts[2]);
                        }
                        catch (NumberFormatException e) {
                            ignoremetaItem = Boolean.parseBoolean(parts[2]);
                        }
                        if (metadataItem == 0 && !ignoremetaItem) {
                            modIdBlock = parts[2];
                            blockName = parts[3];
                            try {
                                metadataItem = Integer.parseInt(parts[4]);
                            }
                            catch (NumberFormatException e) {
                                ignoremetaItem = Boolean.parseBoolean(parts[4]);
                            }
                        } else {
                            modIdBlock = parts[3];
                            blockName = parts[4];
                        }
                        try {
                            igniteChance = Integer.parseInt(parts[5]);
                        }
                        catch (NumberFormatException e) {}
                    } else {
                        modIdItem = parts[0];
                        itemName = parts[1];
                        try {
                            metadataItem = Integer.parseInt(parts[2]);
                        }
                        catch (NumberFormatException e) {
                            ignoremetaItem = Boolean.parseBoolean(parts[2]);
                        }
                        modIdBlock = parts[3];
                        blockName = parts[4];
                        try {
                            metadataBlock = Integer.parseInt(parts[5]);
                        }
                        catch (NumberFormatException e) {
                            ignoremetaBlock = Boolean.parseBoolean(parts[5]);
                        }
                        try {
                            igniteChance = Integer.parseInt(parts[6]);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    Item item = GameRegistry.findItem((String)modIdItem, (String)itemName);
                    block = GameRegistry.findBlock((String)modIdBlock, (String)blockName);
                    if (item == null || block == null) continue;
                    IgnitingList ItemAndBlock = new IgnitingList(item, metadataItem, ignoremetaItem, block, metadataBlock, ignoremetaBlock, igniteChance);
                    IgnitingItems.add(ItemAndBlock);
                    continue;
                }
                if (parts.length != 4) continue;
                String oreDict = parts[0];
                modIdBlock = parts[1];
                blockName = parts[2];
                try {
                    igniteChance = Integer.parseInt(parts[3]);
                }
                catch (NumberFormatException block2) {
                    // empty catch block
                }
                block = GameRegistry.findBlock((String)modIdBlock, (String)blockName);
                List<String> oredictNames = Arrays.asList(OreDictionary.getOreNames());
                if (!oredictNames.contains(oreDict)) continue;
                for (ItemStack oreStack : OreDictionary.getOres((String)oreDict)) {
                    IgnitingList Item2 = new IgnitingList(oreStack.func_77973_b(), oreStack.func_77960_j(), ignoremetaItem, block, metadataBlock, ignoremetaBlock, igniteChance);
                    IgnitingItems.add(Item2);
                }
            }
        }
    }

    public static class IgnitingList {
        public final Item item;
        public final int metadataItem;
        public final boolean ignoremetaItem;
        public final Block block;
        public final int metadataBlock;
        public final boolean ignoremetaBlock;
        public final int igniteChance;

        public IgnitingList(Item item, int metadataItem, boolean ignoremetaItem, Block block, int metadataBlock, boolean ignoremetaBlock, int igniteChance) {
            this.item = item;
            this.metadataItem = metadataItem;
            this.ignoremetaItem = ignoremetaItem;
            this.block = block;
            this.metadataBlock = metadataBlock;
            this.ignoremetaBlock = ignoremetaBlock;
            this.igniteChance = igniteChance;
        }
    }
}

