/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.list;

import com.creativemd.itemphysic.config.ItemPhysicConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class UndestroyableListRegistry {
    public static List<UndestroyableList> UndestroyableItems = new ArrayList<UndestroyableList>();

    public static void registerDefaults() {
        if (ItemPhysicConfig.undestroyableList != null) {
            for (String itemName : ItemPhysicConfig.undestroyableList) {
                List<String> oredictNames;
                int metadata = 0;
                boolean ignoremeta = false;
                String[] parts = itemName.split(":");
                if (parts.length >= 2) {
                    Item item;
                    String modId = parts[0];
                    String itemNameOnly = parts[1];
                    if (parts.length == 3) {
                        try {
                            metadata = Integer.parseInt(parts[2]);
                        }
                        catch (NumberFormatException e) {
                            ignoremeta = Boolean.parseBoolean(parts[2]);
                        }
                    }
                    if ((item = GameRegistry.findItem((String)modId, (String)itemNameOnly)) == null) continue;
                    UndestroyableList Item2 = new UndestroyableList(item, metadata, ignoremeta);
                    UndestroyableItems.add(Item2);
                    continue;
                }
                if (parts.length != 1 || !(oredictNames = Arrays.asList(OreDictionary.getOreNames())).contains(itemName)) continue;
                for (ItemStack oreStack : OreDictionary.getOres((String)itemName)) {
                    UndestroyableList Item3 = new UndestroyableList(oreStack.func_77973_b(), oreStack.func_77960_j(), ignoremeta);
                    UndestroyableItems.add(Item3);
                }
            }
        }
    }

    public static class UndestroyableList {
        public final Item item;
        public final int metadata;
        public final boolean ignoremeta;

        public UndestroyableList(Item item, int metadata, boolean ignoremeta) {
            this.item = item;
            this.metadata = metadata;
            this.ignoremeta = ignoremeta;
        }
    }
}

