/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.mixins.early;

import com.creativemd.itemphysic.config.ItemPhysicConfig;
import com.creativemd.itemphysic.physics.ServerPhysic;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.fluids.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityItem.class}, priority=456)
public abstract class MixinEntityItem
extends Entity {
    @Unique
    Fluid itemPhysic$fluid;
    @Unique
    float itemPhysic$f = 0.98f;
    @Unique
    ItemStack itemPhysic$stack;
    @Unique
    EntityItem itemPhysic$thiz;
    @Shadow
    private int field_70291_e;

    public MixinEntityItem(World worldIn) {
        super(worldIn);
    }

    @Inject(method={"onUpdate"}, at={@At(value="HEAD")})
    public void initFields(CallbackInfo ci) {
        this.itemPhysic$thiz = (EntityItem)this;
        this.itemPhysic$fluid = ServerPhysic.getFluid(this.itemPhysic$thiz);
        this.itemPhysic$stack = this.itemPhysic$thiz.func_70096_w().func_82710_f(10);
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.motionY : D", opcode=181, ordinal=0)})
    private boolean disableMotionYNoFluid(EntityItem instance, double newValue) {
        return this.itemPhysic$fluid == null;
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="net/minecraft/entity/item/EntityItem.func_145771_j (DDD)Z", shift=At.Shift.BEFORE)})
    public void fluidPhysics(CallbackInfo ci) {
        if (this.itemPhysic$fluid != null) {
            double maxSpeedReduction;
            double speedreduction;
            double density = (double)this.itemPhysic$fluid.getDensity() / 1000.0;
            double speed = -1.0 / density * 0.01;
            if (ServerPhysic.canItemSwim(this.itemPhysic$stack, this.itemPhysic$fluid)) {
                speed = 0.05;
            }
            if ((speedreduction = (speed - this.itemPhysic$thiz.field_70181_x) / 2.0) < -(maxSpeedReduction = 0.05)) {
                speedreduction = -maxSpeedReduction;
            }
            if (speedreduction > maxSpeedReduction) {
                speedreduction = maxSpeedReduction;
            }
            this.itemPhysic$thiz.field_70181_x += speedreduction;
            this.itemPhysic$f = (float)(1.0 / density / 1.2);
        }
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.motionY : D", opcode=181, ordinal=1)})
    private boolean disableMotionY(EntityItem instance, double newValue) {
        return false;
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.motionX : D", opcode=181, ordinal=0)})
    private boolean disableMotionX(EntityItem instance, double newValue) {
        return false;
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.motionZ : D", opcode=181, ordinal=0)})
    private boolean disableMotionZ(EntityItem instance, double newValue) {
        return false;
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="INVOKE", target="net/minecraft/entity/item/EntityItem.playSound (Ljava/lang/String;FF)V", ordinal=0)})
    private boolean checkBurnSound(EntityItem instance, String name, float volume, float pitch) {
        return ServerPhysic.canItemBurn(this.itemPhysic$stack);
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="net/minecraft/entity/item/EntityItem.playSound (Ljava/lang/String;FF)V", ordinal=0, shift=At.Shift.AFTER)})
    public void addBurnParticles(CallbackInfo ci) {
        if (ServerPhysic.canItemBurn(this.itemPhysic$stack)) {
            for (int zahl = 0; zahl < 75; ++zahl) {
                this.itemPhysic$thiz.field_70170_p.func_72869_a("smoke", this.itemPhysic$thiz.field_70165_t, this.itemPhysic$thiz.field_70163_u, this.itemPhysic$thiz.field_70161_v, (double)this.field_70146_Z.nextFloat() * 0.1 - 0.05, 0.2 * this.field_70146_Z.nextDouble(), (double)this.field_70146_Z.nextFloat() * 0.1 - 0.05);
            }
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/world/World.isRemote:Z", opcode=180, ordinal=0)})
    public void addIgniting(CallbackInfo ci) {
        if (!this.itemPhysic$thiz.field_70170_p.field_72995_K) {
            Block block = this.itemPhysic$thiz.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.itemPhysic$thiz.field_70165_t), MathHelper.func_76128_c((double)this.itemPhysic$thiz.field_70163_u), MathHelper.func_76128_c((double)this.itemPhysic$thiz.field_70161_v));
            if (this.itemPhysic$thiz.field_70122_E && ServerPhysic.canItemIgnite(this.itemPhysic$stack) && (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151582_l || block.func_149688_o() == Material.field_151593_r) && this.itemPhysic$thiz.field_70170_p.field_73012_v.nextInt(100) <= ServerPhysic.getIgnitingChance(this.itemPhysic$stack)) {
                this.itemPhysic$thiz.field_70170_p.func_147465_d(MathHelper.func_76128_c((double)this.itemPhysic$thiz.field_70165_t), MathHelper.func_76128_c((double)this.itemPhysic$thiz.field_70163_u), MathHelper.func_76128_c((double)this.itemPhysic$thiz.field_70161_v), ServerPhysic.getIgnitingBlock(this.itemPhysic$stack), ServerPhysic.getIgnitingBlockMeta(this.itemPhysic$stack), 3);
            }
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.onGround : Z", opcode=180, ordinal=0)})
    public void addFallSound(CallbackInfo ci) {
        if (this.itemPhysic$thiz.field_70122_E && this.itemPhysic$thiz.field_70167_r != this.itemPhysic$thiz.field_70163_u && ItemPhysicConfig.enableFallSounds) {
            this.itemPhysic$thiz.func_85030_a("dig.cloth", 1.0f, (float)Math.random() + 1.0f);
        }
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.motionY : D", opcode=181, ordinal=2)})
    private boolean checkBurnSound(EntityItem instance, double newValue) {
        return this.itemPhysic$fluid == null;
    }

    @WrapWithCondition(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.motionY : D", opcode=181, ordinal=3)})
    private boolean disableMotionYNoFluid2(EntityItem instance, double newValue) {
        return this.itemPhysic$fluid == null;
    }

    @Inject(method={"onUpdate"}, at={@At(value="FIELD", target="net/minecraft/entity/item/EntityItem.age : I", opcode=181, ordinal=0)}, cancellable=true)
    public void customDespawn(CallbackInfo ci) {
        if (ItemPhysicConfig.enableItemDespawn) {
            ++this.itemPhysic$thiz.field_70292_b;
            if (this.itemPhysic$thiz.lifespan == 6000 && this.itemPhysic$thiz.lifespan != ItemPhysicConfig.despawnItem) {
                this.itemPhysic$thiz.lifespan = ItemPhysicConfig.despawnItem;
            }
            if (!this.itemPhysic$thiz.field_70170_p.field_72995_K && this.itemPhysic$thiz.field_70292_b >= this.itemPhysic$thiz.lifespan) {
                if (this.itemPhysic$stack != null) {
                    ItemExpireEvent event = new ItemExpireEvent(this.itemPhysic$thiz, this.itemPhysic$stack.func_77973_b() == null ? 6000 : this.itemPhysic$stack.func_77973_b().getEntityLifespan(this.itemPhysic$stack, this.itemPhysic$thiz.field_70170_p));
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        this.itemPhysic$thiz.lifespan += event.extraLife;
                    } else {
                        this.itemPhysic$thiz.func_70106_y();
                    }
                } else {
                    this.itemPhysic$thiz.func_70106_y();
                }
            }
        } else {
            ++this.itemPhysic$thiz.field_70292_b;
        }
        if (this.itemPhysic$stack != null && this.itemPhysic$stack.field_77994_a <= 0) {
            this.itemPhysic$thiz.func_70106_y();
        }
        ci.cancel();
    }

    @Overwrite
    public void func_70100_b_(EntityPlayer entityIn) {
        ServerPhysic.onCollideWithPlayer(this.field_70146_Z, (EntityItem)this, entityIn, true);
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (ItemPhysicConfig.customPickup) {
            ServerPhysic.onCollideWithPlayer(this.field_70146_Z, (EntityItem)this, player, false);
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_92059_d() != null) {
            if (ServerPhysic.isItemUndestroyable(this.func_92059_d()) || this.func_85032_ar()) {
                return false;
            }
            if (source.func_94541_c() && !ServerPhysic.canItemExplode(this.func_92059_d())) {
                return false;
            }
            if (!(source != DamageSource.field_76371_c && source != DamageSource.field_76370_b && source != DamageSource.field_76372_a || ServerPhysic.canItemBurn(this.func_92059_d()))) {
                return false;
            }
            if (source == DamageSource.field_76367_g && ItemPhysicConfig.disableCactusDamage) {
                return false;
            }
            if (source.field_76373_n.equals("acid") && !ServerPhysic.canItemDissolve(this.func_92059_d())) {
                return false;
            }
            if (source.func_94541_c()) {
                this.func_70106_y();
            }
            --this.field_70291_e;
            if (this.field_70291_e <= 0) {
                this.func_70106_y();
            }
        }
        return false;
    }

    @Shadow
    public ItemStack func_92059_d() {
        ItemStack itemstack = this.func_70096_w().func_82710_f(10);
        return itemstack == null ? new ItemStack(Blocks.field_150348_b) : itemstack;
    }

    public boolean func_70027_ad() {
        boolean flag = this.field_70170_p != null && this.field_70170_p.field_72995_K;
        return ServerPhysic.canItemBurn(this.func_92059_d()) && !this.field_70178_ae && (this.field_70151_c > 0 || flag && this.func_70083_f(0));
    }
}

