/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.physics;

import com.creativemd.itemphysic.config.ItemPhysicConfig;
import com.creativemd.itemphysic.list.BurnListRegistry;
import com.creativemd.itemphysic.list.ExplosionListRegistry;
import com.creativemd.itemphysic.list.FloatListRegistry;
import com.creativemd.itemphysic.list.IgnitingListRegistry;
import com.creativemd.itemphysic.list.SulfuricAcidListRegistry;
import com.creativemd.itemphysic.list.UndestroyableListRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class ServerPhysic {
    public static Fluid getFluid(EntityItem item) {
        return ServerPhysic.getFluid(item, false);
    }

    public static Fluid getFluid(EntityItem item, boolean below) {
        int k;
        Block block;
        Fluid fluid;
        if (item == null || item.field_70170_p == null) {
            return null;
        }
        double d0 = item.field_70163_u + (double)item.func_70047_e();
        int i = MathHelper.func_76128_c((double)item.field_70165_t);
        int j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0));
        if (below) {
            --j;
        }
        if ((fluid = FluidRegistry.lookupFluidForBlock((Block)(block = item.field_70170_p.func_147439_a(i, j, k = MathHelper.func_76128_c((double)item.field_70161_v))))) == null && block instanceof IFluidBlock) {
            fluid = ((IFluidBlock)block).getFluid();
        } else if (block instanceof BlockLiquid && block.func_149688_o() == Material.field_151586_h) {
            fluid = FluidRegistry.WATER;
        } else if (block instanceof BlockLiquid && block.func_149688_o() == Material.field_151587_i) {
            fluid = FluidRegistry.LAVA;
        }
        if (below) {
            return fluid;
        }
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(item.field_70170_p, i, j, k);
        }
        if (filled < 0.0 ? d0 > (double)j + (1.0 - (filled *= -1.0)) : d0 < (double)j + filled) {
            return fluid;
        }
        return null;
    }

    public static void onCollideWithPlayer(Random rand, EntityItem item, EntityPlayer par1EntityPlayer, boolean needsSneak) {
        if (ItemPhysicConfig.customPickup && needsSneak && !par1EntityPlayer.func_70093_af()) {
            return;
        }
        if (!item.field_70170_p.field_72995_K) {
            if (!ItemPhysicConfig.customPickup && item.field_145804_b > 0) {
                return;
            }
            EntityItemPickupEvent event = new EntityItemPickupEvent(par1EntityPlayer, item);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            ItemStack itemstack = item.func_92059_d();
            int i = itemstack.field_77994_a;
            if (ItemPhysicConfig.customPickup | item.field_145804_b <= 0 && (item.func_145798_i() == null || item.lifespan - item.field_70292_b <= 200 || item.func_145798_i().equals(par1EntityPlayer.func_70005_c_())) && (event.getResult() == Event.Result.ALLOW || i <= 0 || par1EntityPlayer.field_71071_by.func_70441_a(itemstack))) {
                EntityPlayer entityplayer1;
                for (int id : OreDictionary.getOreIDs((ItemStack)itemstack)) {
                    if (OreDictionary.getOreID((String)"logWood") != id) continue;
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76005_g);
                    break;
                }
                if (itemstack.func_77973_b() == Items.field_151116_aA) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76022_t);
                }
                if (itemstack.func_77973_b() == Items.field_151045_i) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76019_w);
                }
                if (itemstack.func_77973_b() == Items.field_151072_bj) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76027_z);
                }
                if (itemstack.func_77973_b() == Items.field_151045_i && item.func_145800_j() != null && (entityplayer1 = item.field_70170_p.func_72924_a(item.func_145800_j())) != null && entityplayer1 != par1EntityPlayer) {
                    entityplayer1.func_71029_a((StatBase)AchievementList.field_150966_x);
                }
                FMLCommonHandler.instance().firePlayerItemPickupEvent(par1EntityPlayer, item);
                item.field_70170_p.func_72956_a((Entity)par1EntityPlayer, "random.pop", 0.2f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)item, i);
                if (itemstack.field_77994_a <= 0) {
                    item.func_70106_y();
                }
            }
        }
    }

    public static boolean canItemSwim(ItemStack stack, Fluid fluid) {
        if (stack != null) {
            for (FloatListRegistry.FloatList floatList : FloatListRegistry.FloatItems) {
                for (int i = 0; i < floatList.liquids.length; ++i) {
                    if (!floatList.liquids[i].equals(fluid.getUnlocalizedName()) || (!floatList.ignoremeta || stack.func_77973_b() != floatList.item) && (stack.func_77973_b() != floatList.item || stack.func_77960_j() != floatList.metadata)) continue;
                    return !ItemPhysicConfig.invertFloatList;
                }
            }
        }
        return ItemPhysicConfig.invertFloatList;
    }

    public static boolean canItemBurn(ItemStack stack) {
        if (stack != null) {
            for (BurnListRegistry.BurnList burnList : BurnListRegistry.BurnItems) {
                if ((!burnList.ignoremeta || stack.func_77973_b() != burnList.item) && (stack.func_77973_b() != burnList.item || stack.func_77960_j() != burnList.metadata)) continue;
                return ItemPhysicConfig.invertBurnList;
            }
        }
        return !ItemPhysicConfig.invertBurnList;
    }

    public static boolean canItemExplode(ItemStack stack) {
        if (stack != null) {
            for (ExplosionListRegistry.ExplosionList itemWithMetaExplosion : ExplosionListRegistry.ExplosionItems) {
                if ((!itemWithMetaExplosion.ignoremeta || stack.func_77973_b() != itemWithMetaExplosion.item) && (stack.func_77973_b() != itemWithMetaExplosion.item || stack.func_77960_j() != itemWithMetaExplosion.metadata)) continue;
                return ItemPhysicConfig.invertExplosionList;
            }
        }
        return !ItemPhysicConfig.invertExplosionList;
    }

    public static boolean isItemUndestroyable(ItemStack stack) {
        if (stack != null) {
            for (UndestroyableListRegistry.UndestroyableList undestroyableList : UndestroyableListRegistry.UndestroyableItems) {
                if ((!undestroyableList.ignoremeta || stack.func_77973_b() != undestroyableList.item) && (stack.func_77973_b() != undestroyableList.item || stack.func_77960_j() != undestroyableList.metadata)) continue;
                return !ItemPhysicConfig.invertUndestroyableList;
            }
        }
        return ItemPhysicConfig.invertUndestroyableList;
    }

    public static boolean canItemDissolve(ItemStack stack) {
        if (stack != null) {
            for (SulfuricAcidListRegistry.SulfuricAcidList itemWithMetaSulfuricAcid : SulfuricAcidListRegistry.SulfuricAcidItems) {
                if ((!itemWithMetaSulfuricAcid.ignoremeta || stack.func_77973_b() != itemWithMetaSulfuricAcid.item) && (stack.func_77973_b() != itemWithMetaSulfuricAcid.item || stack.func_77960_j() != itemWithMetaSulfuricAcid.metadata)) continue;
                return ItemPhysicConfig.invertSulfuricAcidList;
            }
        }
        return !ItemPhysicConfig.invertSulfuricAcidList;
    }

    public static boolean canItemIgnite(ItemStack stack) {
        if (stack != null) {
            for (IgnitingListRegistry.IgnitingList IgnitingList2 : IgnitingListRegistry.IgnitingItems) {
                if ((!IgnitingList2.ignoremetaItem || stack.func_77973_b() != IgnitingList2.item) && (stack.func_77973_b() != IgnitingList2.item || stack.func_77960_j() != IgnitingList2.metadataItem)) continue;
                return !ItemPhysicConfig.invertIgnitingItemsList;
            }
        }
        return ItemPhysicConfig.invertIgnitingItemsList;
    }

    public static Block getIgnitingBlock(ItemStack stack) {
        if (stack != null) {
            for (IgnitingListRegistry.IgnitingList IgnitingList2 : IgnitingListRegistry.IgnitingItems) {
                if ((!IgnitingList2.ignoremetaItem || stack.func_77973_b() != IgnitingList2.item) && (stack.func_77973_b() != IgnitingList2.item || stack.func_77960_j() != IgnitingList2.metadataItem)) continue;
                return IgnitingList2.block;
            }
        }
        return Blocks.field_150480_ab;
    }

    public static int getIgnitingBlockMeta(ItemStack stack) {
        if (stack != null) {
            for (IgnitingListRegistry.IgnitingList IgnitingList2 : IgnitingListRegistry.IgnitingItems) {
                if ((!IgnitingList2.ignoremetaItem || stack.func_77973_b() != IgnitingList2.item) && (stack.func_77973_b() != IgnitingList2.item || stack.func_77960_j() != IgnitingList2.metadataItem)) continue;
                return IgnitingList2.metadataBlock;
            }
        }
        return 0;
    }

    public static int getIgnitingChance(ItemStack stack) {
        if (stack != null) {
            for (IgnitingListRegistry.IgnitingList IgnitingList2 : IgnitingListRegistry.IgnitingItems) {
                if ((!IgnitingList2.ignoremetaItem || stack.func_77973_b() != IgnitingList2.item) && (stack.func_77973_b() != IgnitingList2.item || stack.func_77960_j() != IgnitingList2.metadataItem)) continue;
                return IgnitingList2.igniteChance;
            }
        }
        return 10;
    }
}

