/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyscythe.datagen;

import com.blocklegend001.onlyscythe.item.ModItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.baseScytheRecipe(recipeOutput, (TagKey<Item>)ItemTags.PLANKS, ModItems.WOODEN_SCYTHE);
        this.baseScytheRecipe(recipeOutput, (TagKey<Item>)ItemTags.STONE_TOOL_MATERIALS, ModItems.STONE_SCYTHE);
        this.baseScytheRecipe(recipeOutput, (ItemLike)Items.IRON_INGOT, ModItems.IRON_SCYTHE);
        this.baseScytheRecipe(recipeOutput, (ItemLike)Items.GOLD_INGOT, ModItems.GOLDEN_SCYTHE);
        this.baseScytheRecipe(recipeOutput, (ItemLike)Items.DIAMOND, ModItems.DIAMOND_SCYTHE);
        this.baseSmithingRecipe(recipeOutput, Items.NETHERITE_INGOT, ModItems.DIAMOND_SCYTHE, ModItems.NETHERITE_SCYTHE);
    }

    public void baseScytheRecipe(RecipeOutput output, ItemLike ingredient, Item result) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), ingredient).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("###").pattern("  S").pattern("  S").unlockedBy("has_" + ingredient.asItem().builtInRegistryHolder().key().location().getPath(), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    public void baseScytheRecipe(RecipeOutput output, TagKey<Item> tag, Item result) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("###").pattern("  S").pattern("  S").unlockedBy("has_" + tag.location().getPath(), ModRecipeProvider.has(tag)).save(output);
    }

    public void baseSmithingRecipe(RecipeOutput output, Item base, Item addition, Item result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{addition}), (RecipeCategory)RecipeCategory.MISC, (Item)result).unlocks("has_addition", ModRecipeProvider.has((ItemLike)addition)).save(output, ResourceLocation.fromNamespaceAndPath((String)"onlyscythe", (String)(result.getDescriptionId().replace("item.onlyscythe.", "") + "_smithing")));
    }
}

