/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyscythe.datagen;

import com.blocklegend001.onlyscythe.item.ModItems;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ModModelProvider
extends ModelProvider {
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    protected final String modId;

    public ModModelProvider(PackOutput packOutput, String modId) {
        super(packOutput);
        this.itemInfoPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.modId = modId;
    }

    protected void registerModels(ItemModelGenerators itemModels) {
        this.itemModel(itemModels, ModItems.WOODEN_SCYTHE);
        this.itemModel(itemModels, ModItems.STONE_SCYTHE);
        this.itemModel(itemModels, ModItems.GOLDEN_SCYTHE);
        this.itemModel(itemModels, ModItems.IRON_SCYTHE);
        this.itemModel(itemModels, ModItems.DIAMOND_SCYTHE);
        this.itemModel(itemModels, ModItems.NETHERITE_SCYTHE);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, ModelTemplate template) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.LAYER0, textureLoc);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(template.create(item, textureMapping, itemModels.modelOutput), Collections.emptyList()));
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ModelProvider.ItemInfoCollector itemCollector = new ModelProvider.ItemInfoCollector(this::getKnownItems);
        ModelProvider.SimpleModelCollector simpleModelCollector = new ModelProvider.SimpleModelCollector();
        this.registerModels(new ItemModelGenerators((ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector));
        itemCollector.finalizeAndValidate();
        return CompletableFuture.allOf(simpleModelCollector.save(output, this.modelPathProvider), itemCollector.save(output, this.itemInfoPathProvider));
    }

    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> Optional.of(BuiltInRegistries.ITEM.getKey(item)).filter(key -> key.getNamespace().equals(this.modId)).isPresent());
    }
}

