/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyscythe.datagen;

import com.blocklegend001.onlyscythe.item.ModItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(HolderLookup.Provider lookup, RecipeOutput recipeOutput) {
        super(lookup, recipeOutput);
    }

    protected void buildRecipes() {
        this.baseScytheRecipe(this.output, (TagKey<Item>)ItemTags.PLANKS, ModItems.WOODEN_SCYTHE);
        this.baseScytheRecipe(this.output, (TagKey<Item>)ItemTags.STONE_TOOL_MATERIALS, ModItems.STONE_SCYTHE);
        this.baseScytheRecipe(this.output, (ItemLike)Items.IRON_INGOT, ModItems.IRON_SCYTHE);
        this.baseScytheRecipe(this.output, (ItemLike)Items.GOLD_INGOT, ModItems.GOLDEN_SCYTHE);
        this.baseScytheRecipe(this.output, (ItemLike)Items.DIAMOND, ModItems.DIAMOND_SCYTHE);
        this.baseSmithingRecipe(this.output, Items.NETHERITE_INGOT, ModItems.DIAMOND_SCYTHE, ModItems.NETHERITE_SCYTHE);
    }

    public void baseScytheRecipe(RecipeOutput output, ItemLike ingredient, Item result) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), ingredient).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("###").pattern("  S").pattern("  S").unlockedBy("has_" + ingredient.asItem().builtInRegistryHolder().key().location().getPath(), this.has(ingredient)).save(output);
    }

    public void baseScytheRecipe(RecipeOutput output, TagKey<Item> tag, Item result) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("###").pattern("  S").pattern("  S").unlockedBy("has_" + tag.location().getPath(), this.has(tag)).save(output);
    }

    public void baseSmithingRecipe(RecipeOutput output, Item base, Item addition, Item result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)base), (Ingredient)Ingredient.of((ItemLike)addition), (RecipeCategory)RecipeCategory.MISC, (Item)result).unlocks("has_addition", this.has((ItemLike)addition)).save(output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"onlyscythe", (String)(result.getDescriptionId().replace("item.onlyscythe.", "") + "_smithing"))));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> providerCompletableFuture) {
            super(output, providerCompletableFuture);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new ModRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "Recipes";
        }
    }
}

