/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.xptome;

import bl4ckscor3.mod.xptome.XPTome;
import bl4ckscor3.mod.xptome.openmods.utils.EnchantmentUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;

public class XPTomeItem
extends Item {
    public static final int DEFAULT_MAX_XP = 1395;
    private static final Component TOOLTIP_STORE_MAX = Component.translatable((String)"xpbook.tooltip.store.max").withStyle(ChatFormatting.GRAY);
    private static final Component TOOLTIP_STORE_PREVIOUS = Component.translatable((String)"xpbook.tooltip.store.previous").withStyle(ChatFormatting.GRAY);
    private static final Component TOOLTIP_RETRIEVE_MAX = Component.translatable((String)"xpbook.tooltip.retrieve.max").withStyle(ChatFormatting.GRAY);
    private static final Component TOOLTIP_RETRIEVE_NEXT = Component.translatable((String)"xpbook.tooltip.retrieve.next").withStyle(ChatFormatting.GRAY);
    private static final Component TOOLTIP_RETRIEVES_AS_ORBS = Component.translatable((String)"xpbook.tooltip.retrieve.orb").withStyle(ChatFormatting.AQUA);

    public XPTomeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int storedXP = XPTomeItem.getStoredXP(stack);
        if (stack.getCount() > 1) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown() && storedXP < XPTomeItem.getMaxXP(stack)) {
            int xpToStore = 0;
            if (stack.has(XPTome.STORE_UNTIL_PREVIOUS_LEVEL)) {
                int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.experienceLevel);
                xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                if (xpToStore == 0 && player.experienceLevel > 0) {
                    xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.experienceLevel - 1);
                }
            } else {
                xpToStore = EnchantmentUtils.getPlayerXP(player);
            }
            if (xpToStore == 0) {
                return InteractionResult.PASS;
            }
            int actuallyStored = XPTomeItem.addXP(stack, xpToStore);
            if (actuallyStored > 0) {
                int previousLevel = player.experienceLevel;
                NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, -actuallyStored));
                EnchantmentUtils.addPlayerXP(player, -actuallyStored);
                if (previousLevel != player.experienceLevel) {
                    NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.experienceLevel));
                }
            }
            if (!level.isClientSide()) {
                level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (level.random.nextFloat() - level.random.nextFloat()) * 0.35f + 0.9f);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        if (!player.isShiftKeyDown() && storedXP > 0) {
            boolean asOrbs = stack.has(XPTome.RETRIEVE_XP_ORBS);
            if (stack.has(XPTome.RETRIEVE_UNTIL_NEXT_LEVEL)) {
                int xpForPlayer = EnchantmentUtils.getExperienceForLevel(player.experienceLevel + 1) - EnchantmentUtils.getPlayerXP(player);
                double retrievalPercentage = XPTomeItem.getRetrievalPercentage(stack);
                int xpToRetrieve = retrievalPercentage == 0.0 ? 0 : (int)Math.floor((double)xpForPlayer / retrievalPercentage);
                int actuallyRemoved = XPTomeItem.removeXP(stack, xpToRetrieve);
                if (actuallyRemoved < xpForPlayer) {
                    xpForPlayer = (int)Math.floor((double)actuallyRemoved * retrievalPercentage);
                }
                this.addOrSpawnXPForPlayer(player, xpForPlayer, asOrbs);
            } else {
                this.addOrSpawnXPForPlayer(player, (int)Math.ceil((double)storedXP * XPTomeItem.getRetrievalPercentage(stack)), asOrbs);
                XPTomeItem.setStoredXP(stack, 0);
            }
            if (!level.isClientSide() && !asOrbs) {
                float pitchMultiplier = player.experienceLevel > 30 ? 1.0f : (float)player.experienceLevel / 30.0f;
                level.playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    private void addOrSpawnXPForPlayer(Player player, int amount, boolean asOrbs) {
        if (asOrbs) {
            if (!player.level().isClientSide()) {
                player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX(), player.getY(), player.getZ(), amount));
            }
        } else {
            int previousLevel = player.experienceLevel;
            NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, amount));
            EnchantmentUtils.addPlayerXP(player, amount);
            if (previousLevel != player.experienceLevel) {
                NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.experienceLevel));
            }
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.max(0.0, 13.0 * ((double)XPTomeItem.getStoredXP(stack) / (double)XPTomeItem.getMaxXP(stack)));
    }

    public int getBarColor(ItemStack stack) {
        float maxXP = XPTomeItem.getMaxXP(stack);
        float f = Math.max(0.0f, (float)XPTomeItem.getStoredXP(stack) / maxXP);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isFoil(ItemStack stack) {
        return XPTomeItem.getStoredXP(stack) > 0;
    }

    public boolean isCombineRepairable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, TooltipDisplay display, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        if (display.shows((DataComponentType)XPTome.STORE_UNTIL_PREVIOUS_LEVEL.get())) {
            if (stack.has(XPTome.STORE_UNTIL_PREVIOUS_LEVEL)) {
                tooltipAdder.accept(TOOLTIP_STORE_PREVIOUS);
            } else {
                tooltipAdder.accept(TOOLTIP_STORE_MAX);
            }
        }
        if (display.shows((DataComponentType)XPTome.RETRIEVE_UNTIL_NEXT_LEVEL.get())) {
            if (stack.has(XPTome.RETRIEVE_UNTIL_NEXT_LEVEL)) {
                tooltipAdder.accept(TOOLTIP_RETRIEVE_NEXT);
            } else {
                tooltipAdder.accept(TOOLTIP_RETRIEVE_MAX);
            }
        }
        if (stack.has(XPTome.RETRIEVE_XP_ORBS) && display.shows((DataComponentType)XPTome.RETRIEVE_XP_ORBS.get())) {
            tooltipAdder.accept(TOOLTIP_RETRIEVES_AS_ORBS);
        }
        if (display.shows((DataComponentType)XPTome.STORED_XP.get())) {
            int storedXP = XPTomeItem.getStoredXP(stack);
            int maxXP = XPTomeItem.getMaxXP(stack);
            double fillLevel = (double)storedXP / (double)maxXP;
            ChatFormatting color = ChatFormatting.GREEN;
            if (fillLevel >= 1.0) {
                color = ChatFormatting.RED;
            } else if (fillLevel >= 0.9) {
                color = ChatFormatting.YELLOW;
            }
            tooltipAdder.accept((Component)Component.translatable((String)"xpbook.tooltip.stored_xp", (Object[])new Object[]{storedXP, maxXP}).withStyle(color));
        }
    }

    public static int addXP(ItemStack stack, int amount) {
        int maxStorage;
        if (amount <= 0) {
            return 0;
        }
        int stored = XPTomeItem.getStoredXP(stack);
        if (stored >= (maxStorage = XPTomeItem.getMaxXP(stack))) {
            return 0;
        }
        if (stored + amount <= maxStorage) {
            XPTomeItem.setStoredXP(stack, stored + amount);
            return amount;
        }
        XPTomeItem.setStoredXP(stack, maxStorage);
        return maxStorage - stored;
    }

    public static int removeXP(ItemStack stack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int stored = XPTomeItem.getStoredXP(stack);
        if (stored <= 0) {
            return 0;
        }
        if (stored >= amount) {
            XPTomeItem.setStoredXP(stack, stored - amount);
            return amount;
        }
        XPTomeItem.setStoredXP(stack, 0);
        return stored;
    }

    public static void setStoredXP(ItemStack stack, int amount) {
        stack.set(XPTome.STORED_XP, (Object)amount);
    }

    public static int getStoredXP(ItemStack stack) {
        return (Integer)stack.getOrDefault(XPTome.STORED_XP, (Object)0);
    }

    public static int getMaxXP(ItemStack stack) {
        return (Integer)stack.getOrDefault(XPTome.MAXIMUM_XP, (Object)1395);
    }

    public static double getRetrievalPercentage(ItemStack stack) {
        return (Double)stack.getOrDefault(XPTome.RETRIEVAL_PERCENTAGE, (Object)1.0);
    }
}

