/*
 * Decompiled with CFR 0.152.
 */
package cqseur.dailyrewards.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cqseur.dailyrewards.config.ConfigData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcqseur/dailyrewards/config/ConfigManager;", "", "<init>", "()V", "", "init", "loadConfig", "saveConfig", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ljava/nio/file/Path;", "configPath", "Ljava/nio/file/Path;", "Lcqseur/dailyrewards/config/ConfigData;", "value", "config", "Lcqseur/dailyrewards/config/ConfigData;", "getConfig", "()Lcqseur/dailyrewards/config/ConfigData;", "[1.21.3] Dailyrewards_client"})
@Environment(value=EnvType.CLIENT)
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final Path configPath;
    @NotNull
    private static ConfigData config;

    private ConfigManager() {
    }

    @NotNull
    public final ConfigData getConfig() {
        return config;
    }

    public final void init() {
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfig() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                Closeable closeable = Files.newBufferedReader(configPath);
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    ConfigData loadedConfig = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
                    if (loadedConfig != null) {
                        config = loadedConfig;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                System.out.println((Object)("Error loading DailyRewards config: " + e.getMessage()));
                this.saveConfig();
            }
        } else {
            this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveConfig() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Closeable closeable = Files.newBufferedWriter(configPath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                gson.toJson((Object)config, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Error saving DailyRewards config: " + e.getMessage()));
        }
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        ConfigManager.gson = gson;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("dailyrewards.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        configPath = path;
        config = new ConfigData(false, false, false, 0.0f, false, null, 0L, 0, 0, 511, null);
    }
}

