/*
 * Decompiled with CFR 0.152.
 */
package cqseur.dailyrewards.utils.manager;

import cqseur.dailyrewards.config.ConfigData;
import cqseur.dailyrewards.config.ConfigManager;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\tJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\tJ\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0006J\u0015\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0004\b\u0016\u0010\fJ\r\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\fJ\r\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0018\u0010\tJ\r\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\tJ\r\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\tR\u001c\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001c\u0010 \u001a\n \u001c*\u0004\u0018\u00010\u001f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001c\u0010\"\u001a\n \u001c*\u0004\u0018\u00010\u001f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u001c\u0010$\u001a\n \u001c*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcqseur/dailyrewards/utils/manager/DailyClaimManager;", "", "<init>", "()V", "", "canClaimToday", "()Z", "", "getCurrentClaimDate", "()Ljava/lang/String;", "Ljava/time/ZonedDateTime;", "getCurrentHypixelTime", "()Ljava/time/ZonedDateTime;", "getNextResetTime", "getTimeUntilNextReset", "", "recordClaim", "getStreakInfo", "isStreakAtRisk", "hypixelTime", "convertHypixelToLocal", "(Ljava/time/ZonedDateTime;)Ljava/time/ZonedDateTime;", "getCurrentLocalTime", "getNextResetTimeLocal", "getNextResetFullTimeFormatted", "getDisplayTimes", "getDebugInfo", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ljava/time/ZoneId;", "HYPIXEL_TIMEZONE", "Ljava/time/ZoneId;", "LOCAL_ZONE", "Ljava/time/format/DateTimeFormatter;", "DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "[1.21.5] Dailyrewards_client"})
@Environment(value=EnvType.CLIENT)
public final class DailyClaimManager {
    @NotNull
    public static final DailyClaimManager INSTANCE = new DailyClaimManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"[DailyRewards-ClaimManager]");
    private static final ZoneId HYPIXEL_TIMEZONE = ZoneId.of("America/New_York");
    private static final ZoneId LOCAL_ZONE = ZoneId.systemDefault();
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private DailyClaimManager() {
    }

    public final boolean canClaimToday() {
        ConfigData config = ConfigManager.INSTANCE.getConfig();
        String currentClaimDate = this.getCurrentClaimDate();
        if (((CharSequence)config.getLastClaimDate()).length() == 0) {
            logger.info("First time claim - allowing");
            return true;
        }
        boolean canClaim = !Intrinsics.areEqual((Object)currentClaimDate, (Object)config.getLastClaimDate());
        logger.debug("Can claim today: " + canClaim + " (Current: " + currentClaimDate + ", Last: " + config.getLastClaimDate() + ")");
        return canClaim;
    }

    private final String getCurrentClaimDate() {
        ZonedDateTime now = ZonedDateTime.now(HYPIXEL_TIMEZONE);
        boolean resetHour = false;
        LocalDate claimDate = now.getHour() < 0 ? now.minusDays(1L).toLocalDate() : now.toLocalDate();
        String string = claimDate.format(DATE_FORMAT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final ZonedDateTime getCurrentHypixelTime() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(HYPIXEL_TIMEZONE);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime getNextResetTime() {
        ZonedDateTime zonedDateTime;
        int resetHour;
        ZonedDateTime nextReset;
        ZonedDateTime now = ZonedDateTime.now(HYPIXEL_TIMEZONE);
        if (now.isBefore(nextReset = now.withHour(resetHour = 0).withMinute(0).withSecond(0).withNano(0))) {
            ZonedDateTime zonedDateTime2 = nextReset;
            Intrinsics.checkNotNull((Object)zonedDateTime2);
            zonedDateTime = zonedDateTime2;
        } else {
            ZonedDateTime zonedDateTime3 = nextReset.plusDays(1L);
            Intrinsics.checkNotNull((Object)zonedDateTime3);
            zonedDateTime = zonedDateTime3;
        }
        return zonedDateTime;
    }

    @NotNull
    public final String getTimeUntilNextReset() {
        ZonedDateTime now = ZonedDateTime.now(HYPIXEL_TIMEZONE);
        ZonedDateTime nextReset = this.getNextResetTime();
        Duration duration = Duration.between(now, nextReset);
        long hours = duration.toHours();
        long minutes = duration.minusHours(hours).toMinutes();
        long seconds = duration.minusHours(hours).minusMinutes(minutes).toSeconds();
        if (hours >= 1L) {
            return hours + "h " + minutes + "m " + seconds + "s";
        }
        return minutes + " minutes " + seconds + " seconds";
    }

    public final void recordClaim() {
        ConfigData config = ConfigManager.INSTANCE.getConfig();
        String currentClaimDate = this.getCurrentClaimDate();
        long currentTimestamp = System.currentTimeMillis();
        String yesterday = LocalDate.parse(currentClaimDate, DATE_FORMAT).minusDays(1L).format(DATE_FORMAT);
        boolean continuesStreak = Intrinsics.areEqual((Object)config.getLastClaimDate(), (Object)yesterday);
        config.setLastClaimDate(currentClaimDate);
        config.setLastClaimTimestamp(currentTimestamp);
        int n = config.getTotalClaimsCount();
        config.setTotalClaimsCount(n + 1);
        if (continuesStreak) {
            n = config.getCurrentStreakDays();
            config.setCurrentStreakDays(n + 1);
        } else if (((CharSequence)config.getLastClaimDate()).length() == 0) {
            config.setCurrentStreakDays(1);
        } else {
            config.setCurrentStreakDays(1);
        }
        logger.info("Claim recorded for " + currentClaimDate + ". Streak: " + config.getCurrentStreakDays() + " days, Total claims: " + config.getTotalClaimsCount());
        ConfigManager.INSTANCE.saveConfig();
    }

    @NotNull
    public final String getStreakInfo() {
        ConfigData config = ConfigManager.INSTANCE.getConfig();
        int currentStreak = config.getCurrentStreakDays();
        int totalClaims = config.getTotalClaimsCount();
        return currentStreak + " day" + (currentStreak != 1 ? "s" : "") + " streak | " + totalClaims + " total claim" + (totalClaims != 1 ? "s" : "");
    }

    public final boolean isStreakAtRisk() {
        if (!this.canClaimToday()) {
            return false;
        }
        ConfigData config = ConfigManager.INSTANCE.getConfig();
        if (config.getCurrentStreakDays() == 0) {
            return false;
        }
        String currentClaimDate = this.getCurrentClaimDate();
        String lastClaimDate = config.getLastClaimDate();
        if (((CharSequence)lastClaimDate).length() == 0) {
            return false;
        }
        String yesterday = LocalDate.parse(currentClaimDate, DATE_FORMAT).minusDays(1L).format(DATE_FORMAT);
        return Intrinsics.areEqual((Object)lastClaimDate, (Object)yesterday);
    }

    @NotNull
    public final ZonedDateTime convertHypixelToLocal(@NotNull ZonedDateTime hypixelTime) {
        Intrinsics.checkNotNullParameter((Object)hypixelTime, (String)"hypixelTime");
        ZonedDateTime zonedDateTime = hypixelTime.withZoneSameInstant(LOCAL_ZONE);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"withZoneSameInstant(...)");
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime getCurrentLocalTime() {
        ZonedDateTime zonedDateTime = this.getCurrentHypixelTime().withZoneSameInstant(LOCAL_ZONE);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"withZoneSameInstant(...)");
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime getNextResetTimeLocal() {
        return this.convertHypixelToLocal(this.getNextResetTime());
    }

    @NotNull
    public final String getNextResetFullTimeFormatted() {
        ZonedDateTime nextResetLocal = this.getNextResetTimeLocal();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM d, yyyy 'at' HH:mm z");
        String string = nextResetLocal.format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String getDisplayTimes() {
        StringBuilder stringBuilder;
        ZonedDateTime hypixelTime = this.getCurrentHypixelTime();
        ZonedDateTime localTime = this.getCurrentLocalTime();
        ZonedDateTime nextResetLocal = this.getNextResetTimeLocal();
        StringBuilder $this$getDisplayTimes_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDisplayTimes_u24lambda_u240.append("Current time (your timezone): " + localTime).append('\n');
        $this$getDisplayTimes_u24lambda_u240.append("Current time (Hypixel EST): " + hypixelTime).append('\n');
        $this$getDisplayTimes_u24lambda_u240.append("Next reset (your timezone): " + nextResetLocal).append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public final String getDebugInfo() {
        StringBuilder stringBuilder;
        ConfigData config = ConfigManager.INSTANCE.getConfig();
        String currentClaimDate = this.getCurrentClaimDate();
        ZonedDateTime hypixelTime = this.getCurrentHypixelTime();
        ZonedDateTime localTime = this.getCurrentLocalTime();
        ZonedDateTime nextResetHypixel = this.getNextResetTime();
        ZonedDateTime nextResetLocal = this.getNextResetTimeLocal();
        String timeUntilReset = this.getTimeUntilNextReset();
        StringBuilder $this$getDebugInfo_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDebugInfo_u24lambda_u241.append("=== Daily Claim Debug Info (Multi-Timezone) ===").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("\ud83d\udd50 CURRENT TIME:").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Your timezone: " + localTime).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Hypixel (EST): " + hypixelTime).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("\ud83d\udcc5 CLAIM STATUS:").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Current claim date: " + currentClaimDate).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Last claim date: " + config.getLastClaimDate()).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Can claim today: " + INSTANCE.canClaimToday()).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("\ud83d\udd04 RESET INFO:").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Next reset (your timezone): " + nextResetLocal).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Next reset (Hypixel EST): " + nextResetHypixel).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Time until reset: " + timeUntilReset).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("\ud83d\udcca STREAK INFO:").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Current streak: " + config.getCurrentStreakDays() + " days").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Total claims: " + config.getTotalClaimsCount()).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Streak at risk: " + INSTANCE.isStreakAtRisk()).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("\ud83c\udf0d TIMEZONE INFO:").append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Your timezone: " + LOCAL_ZONE.getId()).append('\n');
        $this$getDebugInfo_u24lambda_u241.append("   Hypixel timezone: " + HYPIXEL_TIMEZONE.getId()).append('\n');
        return stringBuilder.toString();
    }
}

