/*
 * Decompiled with CFR 0.152.
 */
package cqseur.dailyrewards;

import cqseur.dailyrewards.config.ConfigManager;
import cqseur.dailyrewards.utils.MessageUtils;
import cqseur.dailyrewards.utils.manager.DailyClaimManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\tJ\u000f\u0010\u0016\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0017\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0003J\r\u0010\u0019\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u0003R\u001c\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010\"\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010!R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010'R\u0014\u0010)\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010'R\u0016\u0010*\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010'\u00a8\u0006+"}, d2={"Lcqseur/dailyrewards/DailyReminder;", "", "<init>", "()V", "", "init", "Lnet/minecraft/class_310;", "client", "onClientTick", "(Lnet/minecraft/class_310;)V", "", "getCurrentServerAddress", "(Lnet/minecraft/class_310;)Ljava/lang/String;", "address", "", "isHypixelServer", "(Ljava/lang/String;)Z", "newAddress", "isHypixel", "onServerChange", "(Ljava/lang/String;Z)V", "handleHypixelReminder", "sendInitialReminder", "sendPeriodicReminder", "triggerReminder", "isCurrentlyOnHypixel", "()Z", "resetReminderState", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "isOnHypixel", "Z", "lastServerAddress", "Ljava/lang/String;", "reminderSent", "", "ticksSinceJoin", "I", "REMINDER_DELAY_TICKS", "REMINDER_INTERVAL_TICKS", "lastReminderTick", "[1.21.4] Dailyrewards_client"})
@Environment(value=EnvType.CLIENT)
public final class DailyReminder {
    @NotNull
    public static final DailyReminder INSTANCE = new DailyReminder();
    private static final Logger logger = LoggerFactory.getLogger((String)"[DailyRewards-Reminder]");
    private static boolean isOnHypixel;
    @Nullable
    private static String lastServerAddress;
    private static boolean reminderSent;
    private static int ticksSinceJoin;
    private static final int REMINDER_DELAY_TICKS;
    private static final int REMINDER_INTERVAL_TICKS;
    private static int lastReminderTick;

    private DailyReminder() {
    }

    public final void init() {
        logger.info("Initializing DailyReminder system");
        ClientTickEvents.END_CLIENT_TICK.register(DailyReminder::init$lambda$0);
    }

    private final void onClientTick(class_310 client) {
        if (!ConfigManager.INSTANCE.getConfig().getDailyReminder()) {
            return;
        }
        if (!DailyClaimManager.INSTANCE.canClaimToday()) {
            return;
        }
        class_746 class_7462 = client.field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        class_638 class_6382 = client.field_1687;
        if (class_6382 == null) {
            return;
        }
        class_638 world = class_6382;
        String currentServerAddress = this.getCurrentServerAddress(client);
        boolean currentlyOnHypixel = this.isHypixelServer(currentServerAddress);
        if (!Intrinsics.areEqual((Object)currentServerAddress, (Object)lastServerAddress)) {
            this.onServerChange(currentServerAddress, currentlyOnHypixel);
        }
        if (currentlyOnHypixel) {
            int n = ticksSinceJoin;
            ticksSinceJoin = n + 1;
            this.handleHypixelReminder(client);
        }
        lastServerAddress = currentServerAddress;
        isOnHypixel = currentlyOnHypixel;
    }

    private final String getCurrentServerAddress(class_310 client) {
        String string;
        Object object = client.method_1558();
        if (object != null && (object = ((class_642)object).field_3761) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isHypixelServer(String address) {
        if (address == null) {
            return false;
        }
        return StringsKt.contains$default((CharSequence)address, (CharSequence)"hypixel", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)address, (CharSequence)"mc.hypixel.net", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)address, (CharSequence)"hypixel.io", (boolean)false, (int)2, null);
    }

    private final void onServerChange(String newAddress, boolean isHypixel) {
        if (isHypixel && newAddress != null) {
            logger.info("Joined Hypixel server: " + newAddress);
            ticksSinceJoin = 0;
            reminderSent = false;
            lastReminderTick = 0;
        } else if (!isHypixel && isOnHypixel) {
            logger.info("Left Hypixel server");
            reminderSent = false;
        }
    }

    private final void handleHypixelReminder(class_310 client) {
        int currentTick;
        class_638 class_6382 = client.field_1687;
        int n = currentTick = class_6382 != null ? (int)class_6382.method_8510() : 0;
        if (!reminderSent && ticksSinceJoin >= REMINDER_DELAY_TICKS) {
            this.sendInitialReminder();
            reminderSent = true;
            lastReminderTick = currentTick;
        }
        if (reminderSent && currentTick - lastReminderTick >= REMINDER_INTERVAL_TICKS) {
            this.sendPeriodicReminder();
            lastReminderTick = currentTick;
        }
    }

    private final void sendInitialReminder() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        client.execute(() -> DailyReminder.sendInitialReminder$lambda$1(player));
    }

    private final void sendPeriodicReminder() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        client.execute(() -> DailyReminder.sendPeriodicReminder$lambda$2(player));
    }

    public final void triggerReminder() {
        if (!isOnHypixel) {
            return;
        }
        this.sendInitialReminder();
    }

    public final boolean isCurrentlyOnHypixel() {
        return isOnHypixel;
    }

    public final void resetReminderState() {
        reminderSent = false;
        ticksSinceJoin = 0;
        lastReminderTick = 0;
        logger.info("Reminder state reset");
    }

    private static final void init$lambda$0(class_310 client) {
        Intrinsics.checkNotNull((Object)client);
        INSTANCE.onClientTick(client);
    }

    private static final void sendInitialReminder$lambda$1(class_746 $player) {
        block0: {
            MessageUtils.INSTANCE.sendWarning("\u2b50 \u00a76Don't forget to claim your daily rewards!");
            class_746 class_7462 = $player;
            if (class_7462 == null) break block0;
            class_7462.method_5783((class_3414)class_3417.field_14622.comp_349(), 1.0f, 1.0f);
        }
    }

    private static final void sendPeriodicReminder$lambda$2(class_746 $player) {
        block0: {
            MessageUtils.INSTANCE.sendWarning("\u231a \u00a76Reminder: You still haven't claimed your daily rewards !");
            class_746 class_7462 = $player;
            if (class_7462 == null) break block0;
            class_7462.method_5783((class_3414)class_3417.field_14622.comp_349(), 1.0f, 1.0f);
        }
    }

    static {
        REMINDER_DELAY_TICKS = 100;
        REMINDER_INTERVAL_TICKS = 6000;
    }
}

