/*
 * Decompiled with CFR 0.152.
 */
package cqseur.dailyrewards.commands.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cqseur.dailyrewards.DailyRewardsClient;
import cqseur.dailyrewards.RewardCard;
import cqseur.dailyrewards.RewardFetcher;
import cqseur.dailyrewards.RewardOffer;
import cqseur.dailyrewards.utils.MessageUtils;
import cqseur.dailyrewards.utils.manager.DailyClaimManager;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0016\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J7\u0010\u001e\u001a\u00020\u001d2\u001e\u0010\u001b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001c\u0010\"\u001a\n !*\u0004\u0018\u00010 0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00198\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcqseur/dailyrewards/commands/debug/DebugCommand;", "", "<init>", "()V", "", "register", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "dispatcher", "registerDebugCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "showTimezoneDebug", "showDisplayTimes", "showFullDebugInfo", "", "checkDeveloperAccess", "()Z", "hasDeveloperAccess", "", "generateDebugCards", "()I", "customStreak", "generateDebugCardsWithStreak", "(Ljava/lang/Integer;)I", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "optionWithRange", "rarity", "Lcqseur/dailyrewards/RewardCard;", "generateCard", "(Lkotlin/Pair;Ljava/lang/String;)Lcqseur/dailyrewards/RewardCard;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "DEV_UUID_RAW", "Ljava/lang/String;", "[1.21.6] Dailyrewards_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nDebugCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugCommand.kt\ncqseur/dailyrewards/commands/debug/DebugCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1869#2,2:224\n1869#2,2:226\n*S KotlinDebug\n*F\n+ 1 DebugCommand.kt\ncqseur/dailyrewards/commands/debug/DebugCommand\n*L\n90#1:224,2\n104#1:226,2\n*E\n"})
public final class DebugCommand {
    @NotNull
    public static final DebugCommand INSTANCE = new DebugCommand();
    private static final Logger logger = LoggerFactory.getLogger((String)"[DailyRewards-Debug]");
    @NotNull
    private static final String DEV_UUID_RAW = "6d1c17283f5e4ea4ba64a2cebb6c6a3e";

    private DebugCommand() {
    }

    public final void register() {
        ClientCommandRegistrationCallback.EVENT.register(DebugCommand::register$lambda$0);
    }

    private final void registerDebugCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dailyrewards-debug").requires(DebugCommand::registerDebugCommands$lambda$1)).then(ClientCommandManager.literal((String)"timezone").executes(DebugCommand::registerDebugCommands$lambda$2))).then(ClientCommandManager.literal((String)"times").executes(DebugCommand::registerDebugCommands$lambda$3))).then(ClientCommandManager.literal((String)"full").executes(DebugCommand::registerDebugCommands$lambda$4)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debugcards").requires(DebugCommand::registerDebugCommands$lambda$5)).executes(DebugCommand::registerDebugCommands$lambda$6)).then(ClientCommandManager.literal((String)"streak").then(ClientCommandManager.argument((String)"value", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(DebugCommand::registerDebugCommands$lambda$7))));
    }

    private final void showTimezoneDebug() {
        if (!this.checkDeveloperAccess()) {
            return;
        }
        logger.info("=== TIMEZONE DEBUG ===");
        ZonedDateTime hypixelTime = DailyClaimManager.INSTANCE.getCurrentHypixelTime();
        ZonedDateTime localTime = DailyClaimManager.INSTANCE.getCurrentLocalTime();
        MessageUtils.INSTANCE.sendInfo("\ud83c\udf0d Timezone Debug:");
        MessageUtils.INSTANCE.sendMessage("\u00a77Hypixel (EST): \u00a7f" + hypixelTime);
        MessageUtils.INSTANCE.sendMessage("\u00a77Your timezone: \u00a7f" + localTime);
    }

    private final void showDisplayTimes() {
        if (!this.checkDeveloperAccess()) {
            return;
        }
        logger.info("=== DISPLAY TIMES DEBUG ===");
        String displayTimes = DailyClaimManager.INSTANCE.getDisplayTimes();
        MessageUtils.INSTANCE.sendInfo("\ud83d\udd50 Current Times:");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)displayTimes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)line))) continue;
            MessageUtils.INSTANCE.sendMessage("\u00a77" + line);
        }
    }

    private final void showFullDebugInfo() {
        if (!this.checkDeveloperAccess()) {
            return;
        }
        logger.info("=== FULL DEBUG INFO ===");
        String debugInfo = DailyClaimManager.INSTANCE.getDebugInfo();
        MessageUtils.INSTANCE.sendInfo("\ud83d\udd0d Full Debug Info:");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)debugInfo);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)line))) continue;
            if (StringsKt.startsWith$default((String)line, (String)"===", (boolean)false, (int)2, null)) {
                MessageUtils.INSTANCE.sendMessage("\u00a7e" + line);
                continue;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"\ud83d\udd50", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"\ud83d\udcc5", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"\ud83d\udd04", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"\ud83d\udcca", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"\ud83c\udf0d", (boolean)false, (int)2, null)) {
                MessageUtils.INSTANCE.sendMessage("\u00a76" + line);
                continue;
            }
            MessageUtils.INSTANCE.sendMessage("\u00a77" + line);
        }
    }

    private final boolean checkDeveloperAccess() {
        Object currentUuidRaw;
        class_310 mc = class_310.method_1551();
        Object object = mc.field_1724;
        if (object == null || (object = object.method_5667()) == null || (object = ((UUID)object).toString()) == null || (object = StringsKt.replace$default((String)object, (String)"-", (String)"", (boolean)false, (int)4, null)) == null) {
            object = currentUuidRaw = "";
        }
        if (!this.hasDeveloperAccess()) {
            MessageUtils.INSTANCE.sendError("\ud83d\udeab You are not allowed to use debug commands.");
            logger.warn("Unauthorized debug attempt from UUID: " + (String)currentUuidRaw);
            return false;
        }
        return true;
    }

    private final boolean hasDeveloperAccess() {
        class_310 mc = class_310.method_1551();
        Object object = mc.field_1724;
        if (object == null || (object = object.method_5667()) == null || (object = ((UUID)object).toString()) == null || (object = StringsKt.replace$default((String)object, (String)"-", (String)"", (boolean)false, (int)4, null)) == null) {
            object = "";
        }
        Object currentUuidRaw = object;
        return Intrinsics.areEqual((Object)currentUuidRaw, (Object)DEV_UUID_RAW);
    }

    private final int generateDebugCards() {
        return this.generateDebugCardsWithStreak(null);
    }

    private final int generateDebugCardsWithStreak(Integer customStreak) {
        if (!this.checkDeveloperAccess()) {
            return 0;
        }
        int originalStreak = RewardFetcher.INSTANCE.getCurrentStreak();
        int originalHighest = RewardFetcher.INSTANCE.getHighestStreak();
        if (customStreak != null) {
            RewardFetcher.INSTANCE.setCurrentStreak(customStreak);
            RewardFetcher.INSTANCE.setCurrentBarStep(customStreak <= 8 ? customStreak : 8);
            if (customStreak > RewardFetcher.INSTANCE.getHighestStreak()) {
                RewardFetcher.INSTANCE.setHighestStreak(customStreak);
            }
            logger.info("Debug cards with custom streak: " + customStreak + " (was " + originalStreak + "), score=" + RewardFetcher.INSTANCE.getCurrentBarStep());
        } else {
            logger.info("Generating debug cards with current streak: " + originalStreak);
        }
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)new Pair((Object)"Tung Tung Coins", (Object)"coins"), (Object)new IntRange(1000, 10000)), TuplesKt.to((Object)new Pair((Object)"Skibidi Toilet Dust", (Object)"dust"), (Object)new IntRange(1, 20)), TuplesKt.to((Object)new Pair((Object)"Ohio Gyatt Coins Fr Fr", (Object)"coins"), (Object)new IntRange(250, 5000))};
        List commonOptions = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Pair[]{TuplesKt.to((Object)new Pair((Object)"Sigma Male Souls", (Object)"souls"), (Object)new IntRange(2, 10)), TuplesKt.to((Object)new Pair((Object)"BedWars Rizz XP (No Cap)", (Object)"experience"), (Object)new IntRange(100, 1000)), TuplesKt.to((Object)new Pair((Object)"SkyWars Mewing Tokens", (Object)"coins"), (Object)new IntRange(1, 5))};
        List rareOptions = CollectionsKt.listOf((Object[])objectArray2);
        Object[] objectArray3 = new Pair[]{TuplesKt.to((Object)new Pair((Object)"Hypixel Alpha Grindset XP", (Object)"experience"), (Object)new IntRange(1000, 5000)), TuplesKt.to((Object)new Pair((Object)"Gooning Debug Card (Sus)", (Object)"chest_open"), (Object)new IntRange(1, 2))};
        List epicOptions = CollectionsKt.listOf((Object[])objectArray3);
        Object[] objectArray4 = new Pair[]{TuplesKt.to((Object)new Pair((Object)"Chad Reward Token W Rizz", (Object)"adsense_token"), (Object)new IntRange(1, 1)), TuplesKt.to((Object)new Pair((Object)"Sussy Baka Mystery Box", (Object)"mystery_box"), (Object)new IntRange(1, 1))};
        List legendaryOptions = CollectionsKt.listOf((Object[])objectArray4);
        Object[] objectArray5 = new RewardCard[]{this.generateCard((Pair<Pair<String, String>, IntRange>)((Pair)DebugCommand.generateDebugCardsWithStreak$pick(commonOptions)), "common"), this.generateCard((Pair<Pair<String, String>, IntRange>)((Pair)DebugCommand.generateDebugCardsWithStreak$pick(commonOptions)), "common"), this.generateCard((Pair<Pair<String, String>, IntRange>)((Pair)DebugCommand.generateDebugCardsWithStreak$pick(rareOptions)), "rare"), this.generateCard((Pair<Pair<String, String>, IntRange>)((Pair)DebugCommand.generateDebugCardsWithStreak$pick(epicOptions)), "epic"), this.generateCard((Pair<Pair<String, String>, IntRange>)((Pair)DebugCommand.generateDebugCardsWithStreak$pick(legendaryOptions)), "legendary")};
        List cards = CollectionsKt.listOf((Object[])objectArray5);
        RewardOffer offer = new RewardOffer("debug", cards);
        DailyRewardsClient.Companion.setPendingOffer(offer);
        String streakInfo = customStreak != null ? " (Streak: " + customStreak + ")" : " (Current streak: " + RewardFetcher.INSTANCE.getCurrentStreak() + ")";
        MessageUtils.INSTANCE.sendSuccess("\ud83c\udf81 Debug reward cards generated" + streakInfo + "! Screen will open shortly.");
        logger.info("Debug cards generated successfully: " + cards.size() + " cards with streak: " + RewardFetcher.INSTANCE.getCurrentStreak());
        return 1;
    }

    private final RewardCard generateCard(Pair<Pair<String, String>, IntRange> optionWithRange, String rarity) {
        Pair info = (Pair)optionWithRange.component1();
        IntRange range = (IntRange)optionWithRange.component2();
        String name = (String)info.component1();
        String icon = (String)info.component2();
        int amount = RangesKt.random((IntRange)range, (Random)((Random)Random.Default));
        return new RewardCard(name, String.valueOf(amount), "Debug " + name + " (Generated)", rarity, icon);
    }

    private static final void register$lambda$0(CommandDispatcher dispatcher, class_7157 registryAccess) {
        Intrinsics.checkNotNull((Object)dispatcher);
        INSTANCE.registerDebugCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
    }

    private static final boolean registerDebugCommands$lambda$1(FabricClientCommandSource it) {
        return INSTANCE.hasDeveloperAccess();
    }

    private static final int registerDebugCommands$lambda$2(CommandContext context) {
        INSTANCE.showTimezoneDebug();
        return 1;
    }

    private static final int registerDebugCommands$lambda$3(CommandContext context) {
        INSTANCE.showDisplayTimes();
        return 1;
    }

    private static final int registerDebugCommands$lambda$4(CommandContext context) {
        INSTANCE.showFullDebugInfo();
        return 1;
    }

    private static final boolean registerDebugCommands$lambda$5(FabricClientCommandSource it) {
        return INSTANCE.hasDeveloperAccess();
    }

    private static final int registerDebugCommands$lambda$6(CommandContext it) {
        return INSTANCE.generateDebugCards();
    }

    private static final int registerDebugCommands$lambda$7(CommandContext context) {
        int streakValue = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
        return INSTANCE.generateDebugCardsWithStreak(streakValue);
    }

    private static final <T> T generateDebugCardsWithStreak$pick(List<? extends T> list) {
        return list.get(Random.Default.nextInt(list.size()));
    }
}

