/*
 * Decompiled with CFR 0.152.
 */
package dev.siliconcarbidecube.create_redstone_additions.blocks;

import dev.siliconcarbidecube.create_redstone_additions.init.ModBlocks;
import dev.siliconcarbidecube.create_redstone_additions.util.LightLevels;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class Crossroad
extends DiodeBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final IntegerProperty FLANK_POWER = IntegerProperty.m_61631_((String)"flank_power", (int)0, (int)15);
    public static final IntegerProperty MODEL_TYPE = IntegerProperty.m_61631_((String)"model_type", (int)0, (int)3);

    public Crossroad() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_154663_).m_60913_(0.0f, 0.0f).m_60953_(LightLevels::computeLightLevel));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POWER, FLANK_POWER, MODEL_TYPE});
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(this.m_7312_(ctx.m_43725_(), ctx.m_8083_(), state)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int m_6378_(BlockState blockState, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull Direction dir) {
        if ((Integer)blockState.m_61143_((Property)POWER) == 0 && (Integer)blockState.m_61143_((Property)FLANK_POWER) == 0) {
            return 0;
        }
        int power = this.m_5968_(getter, pos, blockState);
        int flankPower = this.getFlankOutputSignal(blockState);
        BlockPos gpos = pos.m_121945_(dir.m_122424_());
        BlockState gbs = getter.m_8055_(gpos);
        if (blockState.m_61143_((Property)f_54117_) == dir || ((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_() == dir) {
            return gbs.m_60713_(Blocks.f_50088_) ? (power > 0 ? power - 1 : 0) : power;
        }
        if (((Direction)blockState.m_61143_((Property)f_54117_)).m_122428_() == dir || ((Direction)blockState.m_61143_((Property)f_54117_)).m_122427_() == dir) {
            return gbs.m_60713_(Blocks.f_50088_) ? (flankPower > 0 ? flankPower - 1 : 0) : flankPower;
        }
        return 0;
    }

    protected int m_5968_(@NotNull BlockGetter getter, @NotNull BlockPos pos, BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    protected int getFlankOutputSignal(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)FLANK_POWER);
    }

    protected boolean m_7320_(@NotNull Level level, @NotNull BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)POWER) > 0;
    }

    protected int m_7312_(Level level, BlockPos pos, BlockState state) {
        Direction directionB = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockposB = pos.m_121945_(directionB);
        Direction directionF = directionB.m_122424_();
        BlockPos blockposF = pos.m_121945_(directionF);
        BlockPos MaxFB = level.m_277185_(blockposF, directionF) > level.m_277185_(blockposB, directionB) ? blockposF : blockposB;
        int i = Math.max(level.m_277185_(blockposF, directionF), level.m_277185_(blockposB, directionB));
        BlockState blockstate = level.m_8055_(MaxFB);
        if (blockstate.m_60713_((Block)ModBlocks.DIODE_BLOCK.get()) || blockstate.m_60713_((Block)ModBlocks.CROSSROAD_BLOCK.get())) {
            i = i != 0 ? i - 1 : 0;
        }
        return blockstate.m_60713_(Blocks.f_50088_) ? (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_) : i;
    }

    protected int getFlankInputSignal(Level level, BlockPos pos, BlockState state) {
        Direction directionL = ((Direction)state.m_61143_((Property)f_54117_)).m_122427_();
        BlockPos blockposL = pos.m_121945_(directionL);
        Direction directionR = directionL.m_122424_();
        BlockPos blockposR = pos.m_121945_(directionR);
        BlockPos MaxRL = level.m_277185_(blockposR, directionR) > level.m_277185_(blockposL, directionL) ? blockposR : blockposL;
        int i = Math.max(level.m_277185_(blockposR, directionR), level.m_277185_(blockposL, directionL));
        BlockState blockstate = level.m_8055_(MaxRL);
        if (blockstate.m_60713_((Block)ModBlocks.DIODE_BLOCK.get()) || blockstate.m_60713_((Block)ModBlocks.CROSSROAD_BLOCK.get())) {
            i = i != 0 ? i - 1 : 0;
        }
        return blockstate.m_60713_(Blocks.f_50088_) ? (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_) : i;
    }

    public void m_213897_(@NotNull BlockState p_221065_, @NotNull ServerLevel p_221066_, @NotNull BlockPos p_221067_, @NotNull RandomSource p_221068_) {
        if (!this.m_7346_((LevelReader)p_221066_, p_221067_, p_221065_)) {
            int flag = (Integer)p_221065_.m_61143_((Property)POWER);
            int flag1 = this.m_7312_((Level)p_221066_, p_221067_, p_221065_);
            int flankFlag = (Integer)p_221065_.m_61143_((Property)FLANK_POWER);
            int flankFlag1 = this.getFlankInputSignal((Level)p_221066_, p_221067_, p_221065_);
            if (flankFlag != 0 && flankFlag1 == 0) {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)FLANK_POWER, (Comparable)Integer.valueOf(0)), 2);
            } else {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)FLANK_POWER, (Comparable)Integer.valueOf(flankFlag1)), 2);
            }
            p_221065_ = p_221066_.m_8055_(p_221067_);
            if (flag != 0 && flag1 == 0) {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)), 2);
            } else {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)POWER, (Comparable)Integer.valueOf(flag1)), 2);
            }
            p_221065_ = p_221066_.m_8055_(p_221067_);
            flag = (Integer)p_221065_.m_61143_((Property)POWER);
            flankFlag = (Integer)p_221065_.m_61143_((Property)FLANK_POWER);
            if (flag != 0 && flankFlag != 0) {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)MODEL_TYPE, (Comparable)Integer.valueOf(3)), 2);
            } else if (flag != 0) {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)MODEL_TYPE, (Comparable)Integer.valueOf(2)), 2);
            } else if (flankFlag != 0) {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)MODEL_TYPE, (Comparable)Integer.valueOf(1)), 2);
            } else {
                p_221066_.m_7731_(p_221067_, (BlockState)p_221065_.m_61124_((Property)MODEL_TYPE, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    protected void m_7321_(@NotNull Level p_52577_, @NotNull BlockPos p_52578_, @NotNull BlockState p_52579_) {
        if (!this.m_7346_((LevelReader)p_52577_, p_52578_, p_52579_)) {
            int flag = (Integer)p_52579_.m_61143_((Property)POWER);
            int flag1 = this.m_7312_(p_52577_, p_52578_, p_52579_);
            int flankFlag = (Integer)p_52579_.m_61143_((Property)FLANK_POWER);
            int flankFlag1 = this.getFlankInputSignal(p_52577_, p_52578_, p_52579_);
            if (!(flag == flag1 && flankFlag == flankFlag1 || p_52577_.m_183326_().m_183588_(p_52578_, (Object)this))) {
                TickPriority tickpriority = TickPriority.HIGH;
                if (this.m_52573_((BlockGetter)p_52577_, p_52578_, p_52579_)) {
                    tickpriority = TickPriority.EXTREMELY_HIGH;
                } else if (flag != 0 || flankFlag != 0) {
                    tickpriority = TickPriority.VERY_HIGH;
                }
                p_52577_.m_186464_(p_52578_, (Block)this, this.m_6112_(p_52579_), tickpriority);
            }
        }
    }

    protected void m_52580_(Level level, BlockPos pos, BlockState state) {
        Direction directionF = (Direction)state.m_61143_((Property)f_54117_);
        Direction directionL = directionF.m_122428_();
        Direction directionR = directionF.m_122427_();
        Direction directionB = directionF.m_122424_();
        BlockPos blockposF = pos.m_121945_(directionF.m_122424_());
        BlockPos blockposL = pos.m_121945_(directionL.m_122424_());
        BlockPos blockposR = pos.m_121945_(directionR.m_122424_());
        BlockPos blockposB = pos.m_121945_(directionB.m_122424_());
        level.m_46586_(blockposF, (Block)this, pos);
        level.m_46590_(blockposF, (Block)this, directionF);
        level.m_46586_(blockposL, (Block)this, pos);
        level.m_46590_(blockposL, (Block)this, directionL);
        level.m_46586_(blockposR, (Block)this, pos);
        level.m_46590_(blockposR, (Block)this, directionR);
        level.m_46586_(blockposB, (Block)this, pos);
        level.m_46590_(blockposB, (Block)this, directionB);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && !this.m_7346_((LevelReader)level, pos, state)) {
            int modelType;
            int newPower = this.m_7312_(level, pos, state);
            int oldPower = (Integer)state.m_61143_((Property)POWER);
            if (oldPower != newPower) {
                state = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower));
                level.m_7731_(pos, state, 2);
                this.m_52580_(level, pos, state);
            }
            int newFlank = this.getFlankInputSignal(level, pos, state);
            int oldFlank = (Integer)state.m_61143_((Property)FLANK_POWER);
            if (oldFlank != newFlank) {
                state = (BlockState)state.m_61124_((Property)FLANK_POWER, (Comparable)Integer.valueOf(newFlank));
                level.m_7731_(pos, state, 2);
                this.m_52580_(level, pos, state);
            }
            int n = (Integer)state.m_61143_((Property)POWER) > 0 && (Integer)state.m_61143_((Property)FLANK_POWER) > 0 ? 3 : ((Integer)state.m_61143_((Property)POWER) > 0 ? 2 : (modelType = (Integer)state.m_61143_((Property)FLANK_POWER) > 0 ? 1 : 0));
            if ((Integer)state.m_61143_((Property)MODEL_TYPE) != modelType) {
                state = (BlockState)state.m_61124_((Property)MODEL_TYPE, (Comparable)Integer.valueOf(modelType));
                level.m_7731_(pos, state, 2);
            }
        }
    }

    private static void makeParticle(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction direction = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        double x = (double)pos.m_123341_() + 0.5 - 0.1 * (double)direction.m_122429_();
        double y = (double)pos.m_123342_() + 0.35;
        double z = (double)pos.m_123343_() + 0.5 - 0.1 * (double)direction.m_122431_();
        level.m_7106_((ParticleOptions)new DustParticleOptions(DustParticleOptions.f_175788_, 0.9f), x, y, z, 0.0, 0.0, 0.0);
    }

    public void m_214162_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Integer)state.m_61143_((Property)POWER) > 0 || (Integer)state.m_61143_((Property)FLANK_POWER) > 0) && random.m_188501_() > 0.4f) {
            Crossroad.makeParticle(state, (LevelAccessor)level, pos);
        }
    }

    protected int m_6112_(@NotNull BlockState blockState) {
        return 0;
    }
}

