/*
 * Decompiled with CFR 0.152.
 */
package dev.siliconcarbidecube.create_redstone_additions.blocks;

import dev.siliconcarbidecube.create_redstone_additions.init.ModBlocks;
import dev.siliconcarbidecube.create_redstone_additions.util.LightLevels;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class Diode
extends DiodeBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public Diode() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_154663_).m_60913_(0.0f, 0.0f).m_60953_(LightLevels::computeLightLevel));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POWER});
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(this.m_7312_(ctx.m_43725_(), ctx.m_8083_(), state)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (direction != null) {
            Direction dirFront = (Direction)state.m_61143_((Property)f_54117_);
            Direction dirBack = dirFront.m_122424_();
            return direction == dirFront || direction == dirBack;
        }
        return true;
    }

    public int m_6378_(BlockState blockState, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull Direction dir) {
        if ((Integer)blockState.m_61143_((Property)POWER) == 0) {
            return 0;
        }
        int i = this.m_5968_(getter, pos, blockState);
        BlockPos gpos = pos.m_121945_(dir.m_122424_());
        BlockState gbs = getter.m_8055_(gpos);
        return blockState.m_61143_((Property)f_54117_) == dir ? (gbs.m_60713_(Blocks.f_50088_) ? (i > 0 ? i - 1 : 0) : i) : 0;
    }

    protected int m_5968_(@NotNull BlockGetter getter, @NotNull BlockPos pos, BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    protected boolean m_7320_(@NotNull Level level, @NotNull BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)POWER) > 0;
    }

    protected int m_7312_(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockpos = pos.m_121945_(direction);
        int i = level.m_277185_(blockpos, direction);
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60713_((Block)ModBlocks.DIODE_BLOCK.get()) || blockstate.m_60713_((Block)ModBlocks.CROSSROAD_BLOCK.get())) {
            int n = i = i != 0 ? i - 1 : 0;
        }
        return blockstate.m_60713_(Blocks.f_50088_) ? ((Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_) == 0 ? 0 : (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_) - 1) : i;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && !this.m_7346_((LevelReader)level, pos, state)) {
            int newPower = this.m_7312_(level, pos, state);
            int oldPower = (Integer)state.m_61143_((Property)POWER);
            if (oldPower != newPower) {
                BlockState updated = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower));
                level.m_7731_(pos, updated, 2);
                this.m_52580_(level, pos, updated);
            }
        }
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!this.m_7346_((LevelReader)level, pos, state)) {
            int newPower = this.m_7312_((Level)level, pos, state);
            if ((Integer)state.m_61143_((Property)POWER) != newPower) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), 2);
                this.m_52580_((Level)level, pos, state);
            }
        }
    }

    protected void m_7321_(@NotNull Level p_52577_, @NotNull BlockPos p_52578_, @NotNull BlockState p_52579_) {
        int flag1;
        int flag;
        if (!this.m_7346_((LevelReader)p_52577_, p_52578_, p_52579_) && (flag = ((Integer)p_52579_.m_61143_((Property)POWER)).intValue()) != (flag1 = this.m_7312_(p_52577_, p_52578_, p_52579_)) && !p_52577_.m_183326_().m_183588_(p_52578_, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.m_52573_((BlockGetter)p_52577_, p_52578_, p_52579_)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag > 0) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            p_52577_.m_186464_(p_52578_, (Block)this, this.m_6112_(p_52579_), tickpriority);
        }
    }

    private static void makeParticle(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction direction = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        double x = (double)pos.m_123341_() + 0.5 - 0.1 * (double)direction.m_122429_();
        double y = (double)pos.m_123342_() + 0.35;
        double z = (double)pos.m_123343_() + 0.5 - 0.1 * (double)direction.m_122431_();
        level.m_7106_((ParticleOptions)new DustParticleOptions(DustParticleOptions.f_175788_, 0.9f), x, y, z, 0.0, 0.0, 0.0);
    }

    public void m_214162_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.m_61143_((Property)POWER) > 0 && random.m_188501_() > 0.4f) {
            Diode.makeParticle(state, (LevelAccessor)level, pos);
        }
    }

    protected int m_6112_(@NotNull BlockState blockState) {
        return 0;
    }
}

