/*
 * Decompiled with CFR 0.152.
 */
package com.schinkennugget;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.schinkennugget.Blockabulary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;

@Environment(value=EnvType.CLIENT)
public class BlockabularyFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final File VOCAB_FILE = CONFIG_DIR.resolve("vocab.json").toFile();
    private static final File TXT_FILE = CONFIG_DIR.resolve("vocab.txt").toFile();
    private static List<Map<String, String>> data;
    public static String currentQuestion;
    public static String currentAnswer;

    public static void init() {
        BlockabularyFileManager.loadConfig();
    }

    private static void createDefaultConfig() {
        try {
            if (!VOCAB_FILE.getParentFile().exists()) {
                VOCAB_FILE.getParentFile().mkdirs();
            }
            String defaultJson = "{\n  \"dataFromTxt\": [\n    {\n      \"question\": \"The config-file for Blockabulary is empty.\",\n      \"answer\": \"\",\n      \"timesAsked\": \"0\",\n      \"timesAnsweredCorrectly\": \"0\"\n    },\n    {\n      \"question\": \"The config-file for Blockabulary is empty.\",\n      \"answer\": \"\",\n      \"timesAsked\": \"0\",\n      \"timesAnsweredCorrectly\": \"0\"\n    }\n  ]\n}";
            FileWriter writer = new FileWriter(VOCAB_FILE);
            writer.write(defaultJson);
            writer.close();
            Blockabulary.LOGGER.info("Default config file created: " + VOCAB_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig() {
        try {
            FileReader reader = new FileReader(VOCAB_FILE);
            Type type = new TypeToken<Map<String, List<Map<String, String>>>>(){}.getType();
            Map data = (Map)GSON.fromJson((Reader)reader, type);
            reader.close();
            BlockabularyFileManager.data = (List)data.get("data");
        }
        catch (IOException e) {
            e.printStackTrace();
            Blockabulary.LOGGER.info("vocab.json file was not found");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTxt() {
        if (!TXT_FILE.exists()) return class_1074.method_4662((String)"message.blockabulary.no_txt_found", (Object[])new Object[0]);
        if (VOCAB_FILE.exists()) return class_1074.method_4662((String)"message.blockabulary.cant_overwrite_vocab", (Object[])new Object[0]);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(TXT_FILE));
            try {
                String line;
                ArrayList<String> dataFromTxt = new ArrayList<String>();
                ArrayList<Map<String, String>> dataForJson = new ArrayList<Map<String, String>>();
                Object info = "";
                int numberOfDataLoaded = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    dataFromTxt.add(line.trim());
                }
                for (int i = 0; i < dataFromTxt.size() - 1; ++numberOfDataLoaded, i += 2) {
                    String question = (String)dataFromTxt.get(i);
                    String answer = (String)dataFromTxt.get(i + 1);
                    HashMap<String, String> entry = new HashMap<String, String>();
                    entry.put("question", question);
                    entry.put("answer", answer);
                    entry.put("timesAsked", "0");
                    entry.put("timesAnsweredCorrectly", "0");
                    dataForJson.add(entry);
                    info = (String)info + "Loaded question " + question + "\nLoaded answer " + answer + "\n\n";
                }
                HashMap<String, ArrayList<Map<String, String>>> finalData = new HashMap<String, ArrayList<Map<String, String>>>();
                finalData.put("data", dataForJson);
                try (FileWriter writer = new FileWriter(VOCAB_FILE);){
                    GSON.toJson(finalData, (Appendable)writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string = "Failed to write the json file, because it wasn't found";
                    reader.close();
                    return string;
                }
                data = dataForJson;
                String string = (String)info + "Loaded and saved " + String.valueOf(numberOfDataLoaded) + " questions and answers";
                return string;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    Throwable throwable;
                    throwable.addSuppressed(throwable2);
                }
            }
        }
        catch (IOException e) {
            Blockabulary.LOGGER.info("vocab.txt file could not be loaded, because it wasn't found.");
            e.printStackTrace();
            return class_1074.method_4662((String)"message.blockabulary.no_txt_found", (Object[])new Object[0]) + " and you managed to throw an IOException, how tf did you do that";
        }
    }

    public static String getRandomQuestion() {
        BlockabularyFileManager.loadConfig();
        if (data == null || data.isEmpty()) {
            return "vocab.json is empty or does not exist";
        }
        Random random = new Random();
        Map<String, String> selected = data.get(random.nextInt(data.size()));
        currentQuestion = selected.get("question");
        currentAnswer = selected.get("answer");
        selected.clear();
        return currentQuestion;
    }

    static {
        currentQuestion = null;
        currentAnswer = null;
    }
}

